/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.google.common.collect.Lists;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.inline.AnonymousObjectTransformer;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.ConstructorInvocation;
import org.jetbrains.jet.codegen.inline.FieldRemapper;
import org.jetbrains.jet.codegen.inline.InlineAdapter;
import org.jetbrains.jet.codegen.inline.InlineCodegen;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.InlineException;
import org.jetbrains.jet.codegen.inline.InlineResult;
import org.jetbrains.jet.codegen.inline.InlinedLambdaRemapper;
import org.jetbrains.jet.codegen.inline.InliningContext;
import org.jetbrains.jet.codegen.inline.InvokeCall;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.LocalVarRemapper;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.RemapVisitor;
import org.jetbrains.jet.codegen.inline.TypeRemapper;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.commons.RemappingMethodAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;

public class MethodInliner {
    private final MethodNode node;
    private final Parameters parameters;
    private final InliningContext inliningContext;
    private final FieldRemapper nodeRemapper;
    private final boolean isSameModule;
    private final String errorPrefix;
    private final JetTypeMapper typeMapper;
    private final List<InvokeCall> invokeCalls;
    private final List<ConstructorInvocation> constructorInvocations;
    private final Map<String, String> currentTypeMapping;
    private final InlineResult result;

    public MethodInliner(@NotNull MethodNode node, @NotNull Parameters parameters, @NotNull InliningContext parent, @NotNull FieldRemapper nodeRemapper, boolean isSameModule, @NotNull String errorPrefix) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        if (nodeRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeRemapper", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        if (errorPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPrefix", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        this.invokeCalls = new ArrayList<InvokeCall>();
        this.constructorInvocations = new ArrayList<ConstructorInvocation>();
        this.currentTypeMapping = new HashMap<String, String>();
        this.node = node;
        this.parameters = parameters;
        this.inliningContext = parent;
        this.nodeRemapper = nodeRemapper;
        this.isSameModule = isSameModule;
        this.errorPrefix = errorPrefix;
        this.typeMapper = parent.state.getTypeMapper();
        this.result = InlineResult.create();
    }

    public InlineResult doInline(MethodVisitor adapter, LocalVarRemapper remapper) {
        return this.doInline(adapter, remapper, true);
    }

    public InlineResult doInline(MethodVisitor adapter, LocalVarRemapper remapper, boolean remapReturn) {
        MethodNode transformedNode = this.markPlacesForInlineAndRemoveInlinable(this.node);
        transformedNode = this.doInline(transformedNode);
        MethodInliner.removeClosureAssertions(transformedNode);
        transformedNode.instructions.resetLabels();
        Label end = new Label();
        RemapVisitor visitor = new RemapVisitor(adapter, end, remapper, remapReturn, this.nodeRemapper);
        try {
            transformedNode.accept(visitor);
        }
        catch (Exception e) {
            throw this.wrapException(e, transformedNode, "couldn't inline method call");
        }
        visitor.visitLabel(end);
        return this.result;
    }

    private MethodNode doInline(MethodNode node) {
        final LinkedList<InvokeCall> currentInvokes = new LinkedList<InvokeCall>(this.invokeCalls);
        MethodNode resultNode = new MethodNode(node.access, node.name, node.desc, node.signature, null);
        final Iterator<ConstructorInvocation> iterator2 = this.constructorInvocations.iterator();
        RemappingMethodAdapter remappingMethodAdapter = new RemappingMethodAdapter(resultNode.access, resultNode.desc, resultNode, new TypeRemapper(this.currentTypeMapping));
        InlineAdapter inliner = new InlineAdapter(remappingMethodAdapter, this.parameters.totalSize()){
            private ConstructorInvocation invocation;

            @Override
            public void anew(Type type) {
                if (InlineCodegenUtil.isLambdaConstructorCall(type.getInternalName(), "<init>")) {
                    this.invocation = (ConstructorInvocation)iterator2.next();
                    if (this.invocation.shouldRegenerate()) {
                        Type newLambdaType = Type.getObjectType(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator.genLambdaClassName());
                        MethodInliner.this.currentTypeMapping.put(this.invocation.getOwnerInternalName(), newLambdaType.getInternalName());
                        AnonymousObjectTransformer transformer = new AnonymousObjectTransformer(this.invocation.getOwnerInternalName(), MethodInliner.this.inliningContext.subInlineWithClassRegeneration(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator, MethodInliner.this.currentTypeMapping, this.invocation), MethodInliner.this.isSameModule, newLambdaType);
                        InlineResult transformResult = transformer.doTransform(this.invocation, MethodInliner.this.nodeRemapper);
                        MethodInliner.this.result.addAllClassesToRemove(transformResult);
                        if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda) {
                            MethodInliner.this.result.addClassToRemove(this.invocation.getOwnerInternalName());
                        }
                    }
                }
                super.anew(type);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                    assert (!currentInvokes.isEmpty());
                    InvokeCall invokeCall = (InvokeCall)currentInvokes.remove();
                    LambdaInfo info = invokeCall.lambdaInfo;
                    if (info == null) {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        return;
                    }
                    int valueParamShift = this.getNextLocalIndex();
                    MethodInliner.putStackValuesIntoLocals(info.getParamsWithoutCapturedValOrVar(), valueParamShift, this, desc);
                    Parameters lambdaParameters = info.addAllParameters();
                    InlinedLambdaRemapper newCapturedRemapper = new InlinedLambdaRemapper(info.getLambdaClassType().getInternalName(), MethodInliner.this.nodeRemapper, lambdaParameters);
                    this.setInlining(true);
                    MethodInliner inliner = new MethodInliner(info.getNode(), lambdaParameters, MethodInliner.this.inliningContext.subInlineLambda(info), newCapturedRemapper, true, "Lambda inlining " + info.getLambdaClassType().getInternalName());
                    LocalVarRemapper remapper = new LocalVarRemapper(lambdaParameters, valueParamShift);
                    InlineResult lambdaResult = inliner.doInline(this.mv, remapper);
                    MethodInliner.this.result.addAllClassesToRemove(lambdaResult);
                    Method bridge = MethodInliner.this.typeMapper.mapSignature(ClosureCodegen.getInvokeFunction(info.getFunctionDescriptor())).getAsmMethod();
                    Method delegate = MethodInliner.this.typeMapper.mapSignature(info.getFunctionDescriptor()).getAsmMethod();
                    StackValue.onStack(delegate.getReturnType()).put(bridge.getReturnType(), this);
                    this.setInlining(false);
                } else if (InlineCodegenUtil.isLambdaConstructorCall(owner, name)) {
                    assert (this.invocation != null) : "<init> call not corresponds to new call" + owner + " " + name;
                    if (this.invocation.shouldRegenerate()) {
                        for (CapturedParamInfo capturedParamInfo : this.invocation.getAllRecapturedParameters()) {
                            this.visitFieldInsn(178, capturedParamInfo.getContainingLambdaName(), "$$$" + capturedParamInfo.getOriginalFieldName(), capturedParamInfo.getType().getDescriptor());
                        }
                        super.visitMethodInsn(opcode, this.invocation.getNewLambdaType().getInternalName(), name, this.invocation.getNewConstructorDescriptor(), itf);
                        this.invocation = null;
                    } else {
                        super.visitMethodInsn(opcode, MethodInliner.this.changeOwnerForExternalPackage(owner, opcode), name, desc, itf);
                    }
                } else {
                    super.visitMethodInsn(opcode, MethodInliner.this.changeOwnerForExternalPackage(owner, opcode), name, desc, itf);
                }
            }
        };
        node.accept(inliner);
        return resultNode;
    }

    @NotNull
    public static CapturedParamInfo findCapturedField(FieldInsnNode node, FieldRemapper fieldRemapper) {
        assert (node.name.startsWith("$$$")) : "Captured field template should start with $$$ prefix";
        FieldInsnNode fin = new FieldInsnNode(node.getOpcode(), node.owner, node.name.substring(3), node.desc);
        CapturedParamInfo field = fieldRemapper.findField(fin);
        if (field == null) {
            throw new IllegalStateException("Couldn't find captured field " + node.owner + "." + node.name + " in " + fieldRemapper.getLambdaInternalName());
        }
        CapturedParamInfo capturedParamInfo = field;
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/MethodInliner", "findCapturedField"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public MethodNode prepareNode(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "prepareNode"));
        }
        final int capturedParamsSize = this.parameters.getCaptured().size();
        final int realParametersSize = this.parameters.getReal().size();
        Type[] types = Type.getArgumentTypes(node.desc);
        Type returnType = Type.getReturnType(node.desc);
        ArrayList<Type> capturedTypes = this.parameters.getCapturedTypes();
        Type[] allTypes = ArrayUtil.mergeArrays(types, capturedTypes.toArray(new Type[capturedTypes.size()]));
        node.instructions.resetLabels();
        MethodNode transformedNode = new MethodNode(327680, node.access, node.name, Type.getMethodDescriptor(returnType, allTypes), node.signature, null){
            private final boolean isInliningLambda;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.isInliningLambda = MethodInliner.this.nodeRemapper.isInsideInliningLambda();
            }

            private int getNewIndex(int var) {
                return var + (var < realParametersSize ? 0 : capturedParamsSize);
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, this.getNewIndex(var));
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(this.getNewIndex(var), increment);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, maxLocals + capturedParamsSize);
            }

            @Override
            public void visitLineNumber(int line, Label start) {
                if (this.isInliningLambda) {
                    super.visitLineNumber(line, start);
                }
            }

            @Override
            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (this.isInliningLambda) {
                    super.visitLocalVariable(name, desc, signature, start, end, this.getNewIndex(index));
                }
            }
        };
        node.accept(transformedNode);
        this.transformCaptured(transformedNode);
        MethodNode methodNode = transformedNode;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/MethodInliner", "prepareNode"));
        }
        return methodNode;
    }

    @NotNull
    protected MethodNode markPlacesForInlineAndRemoveInlinable(@NotNull MethodNode node) {
        Frame<SourceValue>[] sources;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        node = this.prepareNode(node);
        Analyzer<SourceValue> analyzer = new Analyzer<SourceValue>(new SourceInterpreter());
        try {
            sources = analyzer.analyze("fake", node);
        }
        catch (AnalyzerException e) {
            throw this.wrapException(e, node, "couldn't inline method call");
        }
        AbstractInsnNode cur = node.instructions.getFirst();
        int index = 0;
        HashSet<LabelNode> deadLabels = new HashSet<LabelNode>();
        while (cur != null) {
            Frame<SourceValue> frame = sources[index];
            if (frame != null && cur.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)cur;
                String owner = methodInsnNode.owner;
                String desc = methodInsnNode.desc;
                String name = methodInsnNode.name;
                int paramLength = Type.getArgumentTypes(desc).length + 1;
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                    AbstractInsnNode insnNode;
                    SourceValue sourceValue = frame.getStack(frame.getStackSize() - paramLength);
                    LambdaInfo lambdaInfo = null;
                    int varIndex = -1;
                    if (sourceValue.insns.size() == 1 && (lambdaInfo = this.getLambdaIfExists(insnNode = sourceValue.insns.iterator().next())) != null) {
                        node.instructions.remove(insnNode);
                    }
                    this.invokeCalls.add(new InvokeCall(varIndex, lambdaInfo));
                } else if (InlineCodegenUtil.isLambdaConstructorCall(owner, name)) {
                    HashMap<Integer, LambdaInfo> lambdaMapping = new HashMap<Integer, LambdaInfo>();
                    int paramStart = frame.getStackSize() - paramLength;
                    for (int i = 0; i < paramLength; ++i) {
                        AbstractInsnNode insnNode;
                        LambdaInfo lambdaInfo;
                        SourceValue sourceValue = frame.getStack(paramStart + i);
                        if (sourceValue.insns.size() != 1 || (lambdaInfo = this.getLambdaIfExists(insnNode = sourceValue.insns.iterator().next())) == null) continue;
                        lambdaMapping.put(i, lambdaInfo);
                        node.instructions.remove(insnNode);
                    }
                    this.constructorInvocations.add(new ConstructorInvocation(owner, desc, lambdaMapping, this.isSameModule, this.inliningContext.classRegeneration));
                }
            }
            AbstractInsnNode prevNode = cur;
            cur = cur.getNext();
            ++index;
            if (frame != null) continue;
            if (prevNode.getType() == 8) {
                deadLabels.add((LabelNode)prevNode);
                continue;
            }
            node.instructions.remove(prevNode);
        }
        List<TryCatchBlockNode> blocks = node.tryCatchBlocks;
        Iterator<TryCatchBlockNode> iterator2 = blocks.iterator();
        while (iterator2.hasNext()) {
            TryCatchBlockNode block = iterator2.next();
            if (!deadLabels.contains(block.start) || !deadLabels.contains(block.end)) continue;
            iterator2.remove();
        }
        MethodNode methodNode = node;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        return methodNode;
    }

    public LambdaInfo getLambdaIfExists(AbstractInsnNode insnNode) {
        if (insnNode.getOpcode() == 25) {
            int varIndex = ((VarInsnNode)insnNode).var;
            if (varIndex < this.parameters.totalSize()) {
                return this.parameters.get(varIndex).getLambda();
            }
        } else if (insnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
            if (fieldInsnNode.name.startsWith("$$$")) {
                return MethodInliner.findCapturedField(fieldInsnNode, this.nodeRemapper).getLambda();
            }
        }
        return null;
    }

    private static void removeClosureAssertions(MethodNode node) {
        AbstractInsnNode cur = node.instructions.getFirst();
        while (cur != null && cur.getNext() != null) {
            AbstractInsnNode next = cur.getNext();
            if (next.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (methodInsnNode.name.equals("checkParameterIsNotNull") && methodInsnNode.owner.equals("kotlin/jvm/internal/Intrinsics")) {
                    AbstractInsnNode prev = cur.getPrevious();
                    assert (cur.getOpcode() == 18) : "checkParameterIsNotNull should go after LDC but " + cur;
                    assert (prev.getOpcode() == 25) : "checkParameterIsNotNull should be invoked on local var but " + prev;
                    node.instructions.remove(prev);
                    node.instructions.remove(cur);
                    cur = next.getNext();
                    node.instructions.remove(next);
                    next = cur;
                }
            }
            cur = next;
        }
    }

    private void transformCaptured(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "transformCaptured"));
        }
        if (this.nodeRemapper.isRoot()) {
            return;
        }
        for (AbstractInsnNode cur = node.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            List<AbstractInsnNode> accessChain;
            AbstractInsnNode insnNode;
            if (!(cur instanceof VarInsnNode) || cur.getOpcode() != 25 || ((VarInsnNode)cur).var != 0 || (insnNode = this.nodeRemapper.foldFieldAccessChainIfNeeded(accessChain = MethodInliner.getCapturedFieldAccessChain((VarInsnNode)cur), node)) == null) continue;
            cur = insnNode;
        }
    }

    @NotNull
    public static List<AbstractInsnNode> getCapturedFieldAccessChain(@NotNull VarInsnNode aload0) {
        if (aload0 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aload0", "org/jetbrains/jet/codegen/inline/MethodInliner", "getCapturedFieldAccessChain"));
        }
        ArrayList<AbstractInsnNode> fieldAccessChain = new ArrayList<AbstractInsnNode>();
        fieldAccessChain.add(aload0);
        AbstractInsnNode next = aload0.getNext();
        while (next != null && next instanceof FieldInsnNode || next instanceof LabelNode) {
            if (next instanceof LabelNode) {
                next = next.getNext();
                continue;
            }
            fieldAccessChain.add(next);
            if (!"this$0".equals(((FieldInsnNode)next).name)) break;
            next = next.getNext();
        }
        ArrayList<AbstractInsnNode> arrayList = fieldAccessChain;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/MethodInliner", "getCapturedFieldAccessChain"));
        }
        return arrayList;
    }

    public static void putStackValuesIntoLocals(List<Type> directOrder, int shift, InstructionAdapter iv, String descriptor) {
        Type[] actualParams = Type.getArgumentTypes(descriptor);
        assert (actualParams.length == directOrder.size()) : "Number of expected and actual params should be equals!";
        int size = 0;
        for (Type next : directOrder) {
            size += next.getSize();
        }
        shift += size;
        int index = directOrder.size();
        for (Type next : Lists.reverse(directOrder)) {
            Type typeOnStack;
            shift -= next.getSize();
            if (!(typeOnStack = actualParams[--index]).equals(next)) {
                StackValue.onStack(typeOnStack).put(next, iv);
            }
            iv.store(shift, next);
        }
    }

    public String changeOwnerForExternalPackage(String type, int opcode) {
        if (this.isSameModule || (opcode & 0xB8) == 0) {
            return type;
        }
        int i = type.indexOf(45);
        if (i >= 0) {
            return type.substring(0, i);
        }
        return type;
    }

    public RuntimeException wrapException(@NotNull Exception originalException, @NotNull MethodNode node, @NotNull String errorSuffix) {
        if (originalException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalException", "org/jetbrains/jet/codegen/inline/MethodInliner", "wrapException"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "wrapException"));
        }
        if (errorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorSuffix", "org/jetbrains/jet/codegen/inline/MethodInliner", "wrapException"));
        }
        if (originalException instanceof InlineException) {
            return new InlineException(this.errorPrefix + ": " + errorSuffix, originalException);
        }
        return new InlineException(this.errorPrefix + ": " + errorSuffix + "\ncause: " + InlineCodegen.getNodeText(node), originalException);
    }
}

