/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallGenerator;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.FieldRemapper;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.InlineException;
import org.jetbrains.jet.codegen.inline.InlineResult;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.LocalVarRemapper;
import org.jetbrains.jet.codegen.inline.MaxCalcNode;
import org.jetbrains.jet.codegen.inline.MethodInliner;
import org.jetbrains.jet.codegen.inline.ParameterInfo;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.RootInliningContext;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.types.lang.InlineStrategy;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InlineCodegen
implements CallGenerator {
    private final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final SimpleFunctionDescriptor functionDescriptor;
    private final JvmMethodSignature jvmSignature;
    private final Call call;
    private final MethodContext context;
    private final ExpressionCodegen codegen;
    private final FrameMap originalFunctionFrame;
    private final boolean asFunctionInline;
    private final int initialFrameSize;
    private final boolean isSameModule;
    protected final List<ParameterInfo> actualParameters;
    protected final Map<Integer, LambdaInfo> expressionMap;
    private LambdaInfo activeLambda;

    public InlineCodegen(@NotNull ExpressionCodegen codegen, @NotNull GenerationState state, @NotNull SimpleFunctionDescriptor functionDescriptor, @NotNull Call call) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        this.actualParameters = new ArrayList<ParameterInfo>();
        this.expressionMap = new HashMap<Integer, LambdaInfo>();
        assert (functionDescriptor.getInlineStrategy().isInline()) : "InlineCodegen could inline only inline function but " + functionDescriptor;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.codegen = codegen;
        this.call = call;
        this.functionDescriptor = functionDescriptor.getOriginal();
        this.bindingContext = codegen.getBindingContext();
        this.initialFrameSize = codegen.getFrameMap().getCurrentSize();
        this.context = (MethodContext)InlineCodegen.getContext(functionDescriptor, state);
        this.originalFunctionFrame = this.context.prepareFrame(this.typeMapper);
        this.jvmSignature = this.typeMapper.mapSignature(functionDescriptor, this.context.getContextKind());
        InlineStrategy inlineStrategy = codegen.getContext().isInlineFunction() ? InlineStrategy.IN_PLACE : functionDescriptor.getInlineStrategy();
        this.asFunctionInline = false;
        this.isSameModule = !(functionDescriptor instanceof DeserializedSimpleFunctionDescriptor) && JvmCodegenUtil.isCallInsideSameModuleAsDeclared(functionDescriptor, codegen.getContext());
    }

    @Override
    public void genCall(CallableMethod callableMethod, ResolvedCall<?> resolvedCall, int mask, ExpressionCodegen codegen) {
        assert (mask == 0) : "Default method invocation couldn't be inlined " + resolvedCall;
        MethodNode node = null;
        try {
            node = this.createMethodNode(callableMethod);
            this.endCall(this.inlineCall(node));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            boolean generateNodeText = !(e instanceof InlineException);
            PsiElement element = BindingContextUtils.descriptorToDeclaration(this.bindingContext, this.codegen.getContext().getContextDescriptor());
            throw new CompilationException("Couldn't inline method call '" + this.functionDescriptor.getName() + "' into \n" + (element != null ? element.getText() : "null psi element " + this.codegen.getContext().getContextDescriptor()) + (generateNodeText ? "\ncause: " + InlineCodegen.getNodeText(node) : ""), e, this.call.getCallElement());
        }
    }

    private void endCall(@NotNull InlineResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/codegen/inline/InlineCodegen", "endCall"));
        }
        this.leaveTemps();
        this.state.getFactory().removeInlinedClasses(result2.getClassesToRemove());
    }

    @NotNull
    private MethodNode createMethodNode(CallableMethod callableMethod) throws ClassNotFoundException, IOException {
        MethodNode node;
        if (this.functionDescriptor instanceof DeserializedSimpleFunctionDescriptor) {
            VirtualFile file = InlineCodegenUtil.getVirtualFileForCallable((DeserializedSimpleFunctionDescriptor)this.functionDescriptor, this.state);
            String methodDesc = callableMethod.getAsmMethod().getDescriptor();
            DeclarationDescriptor parentDescriptor = this.functionDescriptor.getContainingDeclaration();
            if (DescriptorUtils.isTrait(parentDescriptor)) {
                methodDesc = "(" + this.typeMapper.mapType((ClassDescriptor)parentDescriptor).getDescriptor() + methodDesc.substring(1);
            }
            if ((node = InlineCodegenUtil.getMethodNode(file.getInputStream(), this.functionDescriptor.getName().asString(), methodDesc)) == null) {
                throw new RuntimeException("Couldn't obtain compiled function body for " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
        } else {
            PsiElement element = BindingContextUtils.descriptorToDeclaration(this.bindingContext, this.functionDescriptor);
            if (element == null) {
                throw new RuntimeException("Couldn't find declaration for function " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
            JvmMethodSignature jvmSignature = this.typeMapper.mapSignature(this.functionDescriptor, this.context.getContextKind());
            Method asmMethod = jvmSignature.getAsmMethod();
            node = new MethodNode(327680, AsmUtil.getMethodAsmFlags(this.functionDescriptor, this.context.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), null);
            MaxCalcNode adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(node);
            FunctionCodegen.generateMethodBody(adapter, this.functionDescriptor, this.context.getParentContext().intoFunction(this.functionDescriptor), jvmSignature, new FunctionGenerationStrategy.FunctionDefault(this.state, this.functionDescriptor, (JetDeclarationWithBody)element), this.codegen.getParentCodegen());
            ((MethodVisitor)adapter).visitMaxs(-1, -1);
            adapter.visitEnd();
        }
        MethodNode methodNode = node;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        return methodNode;
    }

    private InlineResult inlineCall(MethodNode node) {
        this.generateClosuresBodies();
        ArrayList<ParameterInfo> realParams = new ArrayList<ParameterInfo>(this.actualParameters);
        this.putClosureParametersOnStack();
        List<CapturedParamInfo> captured = this.getAllCaptured();
        Parameters parameters = new Parameters(realParams, Parameters.shiftAndAddStubs(captured, realParams.size()));
        RootInliningContext info = new RootInliningContext(this.expressionMap, this.state, this.codegen.getInlineNameGenerator().subGenerator(this.functionDescriptor.getName().asString()), this.codegen.getContext(), this.call, this.codegen.getParentCodegen().getClassName());
        MethodInliner inliner = new MethodInliner(node, parameters, info, new FieldRemapper(null, null, parameters), this.isSameModule, "Method inlining " + this.call.getCallElement().getText());
        LocalVarRemapper remapper = new LocalVarRemapper(parameters, this.initialFrameSize);
        return inliner.doInline(this.codegen.v, remapper);
    }

    private void generateClosuresBodies() {
        for (LambdaInfo info : this.expressionMap.values()) {
            info.setNode(this.generateLambdaBody(info));
        }
    }

    private MethodNode generateLambdaBody(LambdaInfo info) {
        JetFunctionLiteral declaration = info.getFunctionLiteral();
        FunctionDescriptor descriptor = info.getFunctionDescriptor();
        MethodContext parentContext = this.codegen.getContext();
        MethodContext context = parentContext.intoClosure(descriptor, this.codegen, this.typeMapper).intoInlinedLambda(descriptor);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(descriptor);
        Method asmMethod = jvmMethodSignature.getAsmMethod();
        MethodNode methodNode = new MethodNode(327680, AsmUtil.getMethodAsmFlags(descriptor, context.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmMethodSignature.getGenericsSignature(), null);
        MaxCalcNode adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(methodNode);
        FunctionCodegen.generateMethodBody(adapter, descriptor, context, jvmMethodSignature, new FunctionGenerationStrategy.FunctionDefault(this.state, descriptor, declaration), this.codegen.getParentCodegen());
        ((MethodVisitor)adapter).visitMaxs(-1, -1);
        return methodNode;
    }

    @Override
    public void afterParameterPut(@NotNull Type type, @Nullable StackValue stackValue, ValueParameterDescriptor valueParameterDescriptor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/InlineCodegen", "afterParameterPut"));
        }
        this.putCapturedInLocal(type, stackValue, valueParameterDescriptor, -1);
    }

    public void putCapturedInLocal(@NotNull Type type, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor, int capturedParamIndex) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putCapturedInLocal"));
        }
        if (!this.asFunctionInline && Type.VOID_TYPE != type) {
            boolean couldBeRemapped = !this.shouldPutValue(type, stackValue, valueParameterDescriptor);
            StackValue remappedIndex = couldBeRemapped ? stackValue : null;
            ParameterInfo info = new ParameterInfo(type, false, couldBeRemapped ? -1 : this.codegen.getFrameMap().enterTemp(type), remappedIndex);
            if (capturedParamIndex >= 0 && couldBeRemapped) {
                CapturedParamInfo capturedParamInfo = this.activeLambda.getCapturedVars().get(capturedParamIndex);
                capturedParamInfo.setRemapValue(remappedIndex != null ? remappedIndex : StackValue.local(info.getIndex(), info.getType()));
            }
            this.doWithParameter(info);
        }
    }

    public boolean shouldPutValue(@NotNull Type type, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor descriptor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/InlineCodegen", "shouldPutValue"));
        }
        if (stackValue == null) {
            return true;
        }
        if (AsmUtil.isPrimitive(type) != AsmUtil.isPrimitive(stackValue.type)) {
            return true;
        }
        if (stackValue instanceof StackValue.Local) {
            return false;
        }
        return !(stackValue instanceof StackValue.Composed) || !this.codegen.getContext().isInliningLambda() || !(this.codegen.getContext().getContextDescriptor() instanceof AnonymousFunctionDescriptor) || descriptor == null || InlineUtil.hasNoinlineAnnotation(descriptor);
    }

    private void doWithParameter(ParameterInfo info) {
        this.recordParamInfo(info, true);
        this.putParameterOnStack(info);
    }

    private int recordParamInfo(ParameterInfo info, boolean addToFrame) {
        Type type = info.type;
        this.actualParameters.add(info);
        if (info.getType().getSize() == 2) {
            this.actualParameters.add(ParameterInfo.STUB);
        }
        if (addToFrame) {
            return this.originalFunctionFrame.enterTemp(type);
        }
        return -1;
    }

    private void putParameterOnStack(ParameterInfo info) {
        if (!info.isSkippedOrRemapped()) {
            int index = info.getIndex();
            Type type = info.type;
            StackValue.local(index, type).store(type, this.codegen.v);
        }
    }

    @Override
    public void putHiddenParams() {
        List<JvmMethodParameterSignature> types = this.jvmSignature.getValueParameters();
        if (!InlineCodegen.isStaticMethod(this.functionDescriptor, this.context)) {
            Type type = AsmTypeConstants.OBJECT_TYPE;
            ParameterInfo parameterInfo = new ParameterInfo(type, false, this.codegen.getFrameMap().enterTemp(type), -1);
            this.recordParamInfo(parameterInfo, false);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : types) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) break;
            Type type = jvmMethodParameterSignature.getAsmType();
            ParameterInfo info = new ParameterInfo(type, false, this.codegen.getFrameMap().enterTemp(type), -1);
            this.recordParamInfo(info, false);
        }
        ListIterator<ParameterInfo> iterator2 = this.actualParameters.listIterator(this.actualParameters.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo parameterInfo = iterator2.previous();
            this.putParameterOnStack(parameterInfo);
        }
    }

    public void leaveTemps() {
        FrameMap frameMap = this.codegen.getFrameMap();
        ListIterator<ParameterInfo> iterator2 = this.actualParameters.listIterator(this.actualParameters.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo param = iterator2.previous();
            if (param.isSkippedOrRemapped()) continue;
            frameMap.leaveTemp(param.type);
        }
    }

    public static boolean isInliningClosure(JetExpression expression, ValueParameterDescriptor valueParameterDescriptora) {
        return expression instanceof JetFunctionLiteralExpression && !InlineUtil.hasNoinlineAnnotation(valueParameterDescriptora);
    }

    public void rememberClosure(JetFunctionLiteralExpression expression, Type type) {
        ParameterInfo closureInfo = new ParameterInfo(type, true, -1, -1);
        int index = this.recordParamInfo(closureInfo, true);
        LambdaInfo info = new LambdaInfo(expression, this.typeMapper);
        this.expressionMap.put(index, info);
        closureInfo.setLambda(info);
    }

    private void putClosureParametersOnStack() {
        int currentSize = this.actualParameters.size();
        for (LambdaInfo next : this.expressionMap.values()) {
            if (next.closure == null) continue;
            this.activeLambda = next;
            next.setParamOffset(currentSize);
            this.codegen.pushClosureOnStack(next.closure, false, this);
            currentSize += next.getCapturedVarsSize();
        }
        this.activeLambda = null;
    }

    private List<CapturedParamInfo> getAllCaptured() {
        ArrayList<CapturedParamInfo> result2 = new ArrayList<CapturedParamInfo>();
        for (LambdaInfo next : this.expressionMap.values()) {
            if (next.closure == null) continue;
            result2.addAll(next.getCapturedVars());
        }
        return result2;
    }

    public static CodegenContext getContext(DeclarationDescriptor descriptor, GenerationState state) {
        if (descriptor instanceof PackageFragmentDescriptor) {
            return new PackageContext((PackageFragmentDescriptor)descriptor, null, null);
        }
        CodegenContext parent = InlineCodegen.getContext(descriptor.getContainingDeclaration(), state);
        if (descriptor instanceof ClassDescriptor) {
            OwnerKind kind = DescriptorUtils.isTrait(descriptor) ? OwnerKind.TRAIT_IMPL : OwnerKind.IMPLEMENTATION;
            return parent.intoClass((ClassDescriptor)descriptor, kind, state);
        }
        if (descriptor instanceof FunctionDescriptor) {
            return parent.intoFunction((FunctionDescriptor)descriptor);
        }
        throw new IllegalStateException("Couldn't build context for " + InlineCodegen.descriptorName(descriptor));
    }

    private static boolean isStaticMethod(FunctionDescriptor functionDescriptor, MethodContext context) {
        return (AsmUtil.getMethodAsmFlags(functionDescriptor, context.getContextKind()) & 8) != 0;
    }

    @NotNull
    public static String getNodeText(@Nullable MethodNode node) {
        if (node == null) {
            if ("Not generated" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegen", "getNodeText"));
            }
            return "Not generated";
        }
        Textifier p = new Textifier();
        node.accept(new TraceMethodVisitor(p));
        StringWriter sw = new StringWriter();
        p.print(new PrintWriter(sw));
        sw.flush();
        String string = node.name + " " + node.desc + ": \n " + sw.getBuffer().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegen", "getNodeText"));
        }
        return string;
    }

    private static String descriptorName(DeclarationDescriptor descriptor) {
        return DescriptorRenderer.SHORT_NAMES_IN_TYPES.render(descriptor);
    }

    @Override
    public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (InlineCodegen.isInliningClosure(argumentExpression, valueParameterDescriptor)) {
            this.rememberClosure((JetFunctionLiteralExpression)argumentExpression, parameterType);
        } else {
            StackValue value = this.codegen.gen(argumentExpression);
            if (this.shouldPutValue(parameterType, value, valueParameterDescriptor)) {
                value.put(parameterType, this.codegen.v);
            }
            this.afterParameterPut(parameterType, value, valueParameterDescriptor);
        }
    }

    @Override
    public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (this.shouldPutValue(stackValue.type, stackValue, null)) {
            stackValue.put(stackValue.type, this.codegen.v);
        }
        this.putCapturedInLocal(stackValue.type, stackValue, null, paramIndex);
    }
}

