/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.OutputFile;
import org.jetbrains.jet.codegen.ClassFileFactory;

public class GeneratedClassLoader
extends URLClassLoader {
    private ClassFileFactory state;

    public GeneratedClassLoader(@NotNull ClassFileFactory state, ClassLoader parentClassLoader, URL ... urls) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/GeneratedClassLoader", "<init>"));
        }
        super(urls, parentClassLoader);
        this.state = state;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/GeneratedClassLoader", "findClass"));
        }
        String classFilePath = name.replace('.', '/') + ".class";
        OutputFile outputFile = this.state.get(classFilePath);
        if (outputFile != null) {
            byte[] bytes = outputFile.asByteArray();
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/GeneratedClassLoader", "findClass"));
            }
            return clazz;
        }
        Class<?> clazz = super.findClass(name);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/GeneratedClassLoader", "findClass"));
        }
        return clazz;
    }

    public void dispose() {
        this.state = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        List<OutputFile> list = this.state.asList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/GeneratedClassLoader", "getAllGeneratedFiles"));
        }
        return list;
    }
}

