/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImmediateClassType
extends PsiClassType.Stub {
    private final PsiClass myClass;
    private final PsiSubstitutor mySubstitutor;
    private final PsiManager myManager;
    private String myCanonicalText;
    private String myCanonicalTextAnnotated;
    private String myPresentableText;
    private String myInternalCanonicalText;
    private final PsiClassType.ClassResolveResult myClassResolveResult;

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        this(aClass, substitutor, null, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel level) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        this(aClass, substitutor, level, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel level, PsiAnnotation ... annotations) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        super(level, annotations);
        this.myClassResolveResult = new PsiClassType.ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return PsiImmediateClassType.this.myClass;
            }

            @Override
            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = PsiImmediateClassType.this.mySubstitutor;
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType$1", "getSubstitutor"));
                }
                return psiSubstitutor;
            }

            @Override
            public boolean isValidResult() {
                return true;
            }

            @Override
            public boolean isAccessible() {
                return true;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return true;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };
        this.myClass = aClass;
        this.myManager = aClass.getManager();
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
    }

    @Override
    public PsiClass resolve() {
        return this.myClass;
    }

    @Override
    public String getClassName() {
        return this.myClass.getName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiTypeParameter[] parameters = this.myClass.getTypeParameters();
        if (parameters.length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        ArrayList<PsiType> lst = new ArrayList<PsiType>();
        for (PsiTypeParameter parameter : parameters) {
            PsiType substituted = this.mySubstitutor.substitute(parameter);
            if (substituted == null) continue;
            lst.add(substituted);
        }
        PsiType[] psiTypeArray = lst.toArray(PsiImmediateClassType.createArray(lst.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = this.myClassResolveResult;
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance(this.myClass.getProject()).getElementFactory().createType(this.myClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "rawType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if (this.myPresentableText == null) {
            this.myPresentableText = this.getText(TextType.PRESENTABLE, true);
        }
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String cached;
        String string = cached = annotated ? this.myCanonicalTextAnnotated : this.myCanonicalText;
        if (cached == null) {
            cached = this.getText(TextType.CANONICAL, annotated);
            if (annotated) {
                this.myCanonicalTextAnnotated = cached;
            } else {
                this.myCanonicalText = cached;
            }
        }
        String string2 = cached;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getCanonicalText"));
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        if (this.myInternalCanonicalText == null) {
            this.myInternalCanonicalText = this.getText(TextType.INT_CANONICAL, true);
        }
        String string = this.myInternalCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(@NotNull TextType textType, boolean annotated) {
        if (textType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "getText"));
        }
        assert (this.mySubstitutor.isValid());
        StringBuilder buffer = new StringBuilder();
        this.buildText(this.myClass, this.mySubstitutor, buffer, textType, annotated);
        return buffer.toString();
    }

    private void buildText(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull StringBuilder buffer, @NotNull TextType textType, boolean annotated) {
        String prefix;
        String fqn;
        PsiElement parent;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (textType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult baseResolveResult = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            if (baseClass != null) {
                this.buildText(baseClass, baseResolveResult.getSubstitutor(), buffer, textType, false);
            }
            return;
        }
        boolean qualified = textType != TextType.PRESENTABLE;
        PsiClass enclosingClass = null;
        if (!aClass.hasModifierProperty("static") && (parent = aClass.getParent()) instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) {
            enclosingClass = (PsiClass)parent;
        }
        if (enclosingClass != null) {
            this.buildText(enclosingClass, substitutor, buffer, textType, false);
            buffer.append('.');
        } else if (qualified && (fqn = aClass.getQualifiedName()) != null && !StringUtil.isEmpty(prefix = StringUtil.getPackageName(fqn))) {
            buffer.append(prefix);
            buffer.append('.');
        }
        if (annotated) {
            PsiNameHelper.appendAnnotations(buffer, this.getAnnotations(), qualified);
        }
        buffer.append(aClass.getName());
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            int pos = buffer.length();
            buffer.append('<');
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiType substitutionResult;
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiUtilCore.ensureValid(typeParameter);
                if (i > 0) {
                    buffer.append(',');
                    if (textType == TextType.PRESENTABLE) {
                        buffer.append(' ');
                    }
                }
                if ((substitutionResult = substitutor.substitute(typeParameter)) == null) {
                    buffer.setLength(pos);
                    pos = -1;
                    break;
                }
                PsiUtil.ensureValidType(substitutionResult);
                if (textType == TextType.PRESENTABLE) {
                    buffer.append(substitutionResult.getPresentableText());
                    continue;
                }
                if (textType == TextType.CANONICAL) {
                    buffer.append(substitutionResult.getCanonicalText(annotated));
                    continue;
                }
                buffer.append(substitutionResult.getInternalCanonicalText());
            }
            if (pos >= 0) {
                buffer.append('>');
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid() && this.mySubstitutor.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        PsiType patternType;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "equalsToText"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory();
        try {
            patternType = factory.createTypeFromText(text, this.myClass);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return this.equals(patternType);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myClass.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel != null ? this.myLanguageLevel : PsiUtil.getLanguageLevel(this.myClass);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
        }
        PsiImmediateClassType psiImmediateClassType = level.equals((Object)this.myLanguageLevel) ? this : new PsiImmediateClassType(this.myClass, this.mySubstitutor, level, this.getAnnotations());
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
        }
        return psiImmediateClassType;
    }

    private static enum TextType {
        PRESENTABLE,
        CANONICAL,
        INT_CANONICAL;

    }
}

