/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;

public abstract class JsLiteral
extends JsExpressionImpl {
    public static final JsValueLiteral THIS = new JsThisRef();
    public static final JsNameRef UNDEFINED = new JsNameRef("undefined");
    public static final JsNullLiteral NULL = new JsNullLiteral();
    public static final JsBooleanLiteral TRUE = new JsBooleanLiteral(true);
    public static final JsBooleanLiteral FALSE = new JsBooleanLiteral(false);

    public static JsBooleanLiteral getBoolean(boolean truth) {
        return truth ? TRUE : FALSE;
    }

    public static abstract class JsValueLiteral
    extends JsLiteral {
        protected JsValueLiteral() {
        }

        @Override
        public final boolean isLeaf() {
            return true;
        }
    }

    public static final class JsBooleanLiteral
    extends JsValueLiteral {
        private final boolean value;

        private JsBooleanLiteral(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public void accept(JsVisitor v) {
            v.visitBoolean(this);
        }
    }

    public static final class JsThisRef
    extends JsValueLiteral {
        private JsThisRef() {
        }

        @Override
        public void accept(JsVisitor v) {
            v.visitThis(this);
        }
    }
}

