/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;

public final class FindPreviousVisitor
extends JetTreeVisitor<DangerousData> {
    @NotNull
    private final Map<JetElement, Void> hasDangerous;

    public FindPreviousVisitor(@NotNull DangerousData data2) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "<init>"));
        }
        this.hasDangerous = Maps.newHashMap();
        JetElement node = data2.getDangerousNode();
        PsiElement last = data2.getRootNode().getParent();
        while (node != last) {
            this.hasDangerous.put(node, null);
            PsiElement parent = node.getParent();
            assert (parent instanceof JetElement);
            node = (JetElement)parent;
        }
    }

    @Override
    public Void visitJetElement(@NotNull JetElement element, DangerousData data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "visitJetElement"));
        }
        if (data2.getDangerousNode() == element) {
            return null;
        }
        if (!this.hasDangerous(element)) {
            FindPreviousVisitor.addElement(element, data2);
        } else {
            this.acceptChildrenThatAreBeforeTheDangerousNode(element, data2);
        }
        return null;
    }

    private static boolean addElement(@NotNull JetElement element, @NotNull DangerousData data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "addElement"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "addElement"));
        }
        if (element instanceof JetExpression) {
            data2.getNodesToBeGeneratedBefore().add((JetExpression)element);
            return true;
        }
        return false;
    }

    private void acceptChildrenThatAreBeforeTheDangerousNode(@NotNull JetElement element, @NotNull DangerousData data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "acceptChildrenThatAreBeforeTheDangerousNode"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "acceptChildrenThatAreBeforeTheDangerousNode"));
        }
        for (PsiElement current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!(current instanceof JetElement)) continue;
            ((JetElement)current).accept(this, data2);
            if (this.hasDangerous(element)) break;
        }
    }

    @Override
    public Void visitPrefixExpression(@NotNull JetPrefixExpression expression, @NotNull DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "visitPrefixExpression"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "visitPrefixExpression"));
        }
        if (data2.getDangerousNode() == expression) {
            return null;
        }
        if (!this.hasDangerous(expression)) {
            FindPreviousVisitor.addElement(expression, data2);
            return null;
        }
        if (this.hasDangerous(PsiUtils.getBaseExpression(expression))) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public Void visitCallExpression(@NotNull JetCallExpression expression, @NotNull DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "visitCallExpression"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "visitCallExpression"));
        }
        if (data2.getDangerousNode() == expression) {
            return null;
        }
        if (!this.hasDangerous(expression)) {
            data2.getNodesToBeGeneratedBefore().add(expression);
        } else {
            this.acceptArgumentsThatAreBeforeDangerousNode(expression, data2);
        }
        return null;
    }

    private void acceptArgumentsThatAreBeforeDangerousNode(@NotNull JetCallExpression expression, @NotNull DangerousData data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "acceptArgumentsThatAreBeforeDangerousNode"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "acceptArgumentsThatAreBeforeDangerousNode"));
        }
        for (ValueArgument valueArgument : expression.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null);
            argumentExpression.accept(this, data2);
            if (!this.hasDangerous(argumentExpression)) continue;
            break;
        }
    }

    private boolean hasDangerous(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/k2js/translate/utils/dangerous/FindPreviousVisitor", "hasDangerous"));
        }
        return this.hasDangerous.containsKey(element);
    }
}

