/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.translate.context.TranslationContext;

public final class JsDescriptorUtils {
    private static final Set<String> FAKE_CLASSES = ContainerUtil.immutableSet(DescriptorUtils.getFqNameSafe(KotlinBuiltIns.getInstance().getAny()).asString(), DescriptorUtils.getFqNameSafe(KotlinBuiltIns.getInstance().getIterable()).asString());

    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "valueParametersCount"));
        }
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "hasParameters"));
        }
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isCompareTo(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "isCompareTo"));
        }
        return functionDescriptor.getName().equals(OperatorConventions.COMPARE_TO);
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        if (superclassDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclassDescriptors", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "findAncestorClass"));
        }
        for (ClassDescriptor descriptor : superclassDescriptors) {
            if (descriptor.getKind() != ClassKind.CLASS && descriptor.getKind() != ClassKind.ENUM_CLASS) continue;
            return descriptor;
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getSuperclass"));
        }
        return JsDescriptorUtils.findAncestorClass(DescriptorUtils.getSuperclassDescriptors(classDescriptor));
    }

    @NotNull
    public static List<JetType> getSupertypesWithoutFakes(ClassDescriptor descriptor) {
        Collection<JetType> supertypes = descriptor.getTypeConstructor().getSupertypes();
        List<JetType> list = ContainerUtil.filter(supertypes, new Condition<JetType>(){

            @Override
            public boolean value(JetType type) {
                ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(type);
                return !FAKE_CLASSES.contains(DescriptorUtils.getFqNameSafe(classDescriptor).asString());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getSupertypesWithoutFakes"));
        }
        return list;
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getContainingDeclaration"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        DeclarationDescriptor declarationDescriptor = containing;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    public static boolean isExtension(@NotNull CallableDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "isExtension"));
        }
        return functionDescriptor.getReceiverParameter() != null;
    }

    public static boolean isOverride(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "isOverride"));
        }
        return !descriptor.getOverriddenDescriptors().isEmpty();
    }

    @Nullable
    public static DeclarationDescriptor getExpectedThisDescriptor(@NotNull CallableDescriptor callableDescriptor) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getExpectedThisDescriptor"));
        }
        ReceiverParameterDescriptor expectedThisObject = callableDescriptor.getExpectedThisObject();
        if (expectedThisObject == null) {
            return null;
        }
        return JsDescriptorUtils.getDeclarationDescriptorForReceiver(expectedThisObject.getValue());
    }

    @NotNull
    public static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getDeclarationDescriptorForReceiver"));
        }
        if (!(receiverParameter instanceof ThisReceiver)) {
            throw new UnsupportedOperationException("Unsupported receiver type: " + receiverParameter);
        }
        DeclarationDescriptor declarationDescriptor = ((ThisReceiver)receiverParameter).getDeclarationDescriptor();
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getOriginal();
        if (declarationDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getDeclarationDescriptorForReceiver"));
        }
        return declarationDescriptor2;
    }

    @Nullable
    public static DeclarationDescriptor getExpectedReceiverDescriptor(@NotNull CallableDescriptor callableDescriptor) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getExpectedReceiverDescriptor"));
        }
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        if (receiverParameter == null) {
            return null;
        }
        return JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter.getValue());
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getContainingClass"));
        }
        for (DeclarationDescriptor containing = descriptor.getContainingDeclaration(); containing != null; containing = containing.getContainingDeclaration()) {
            if (!(containing instanceof ClassDescriptor) || DescriptorUtils.isClassObject(containing)) continue;
            return (ClassDescriptor)containing;
        }
        return null;
    }

    @Nullable
    public static FunctionDescriptor getOverriddenDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getOverriddenDescriptor"));
        }
        Set<? extends FunctionDescriptor> overriddenDescriptors = functionDescriptor.getOverriddenDescriptors();
        if (overriddenDescriptors.isEmpty()) {
            return null;
        }
        return overriddenDescriptors.iterator().next();
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault();
    }

    public static boolean isSimpleFinalProperty(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "isSimpleFinalProperty"));
        }
        return !JsDescriptorUtils.isExtension(propertyDescriptor) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter()) && !propertyDescriptor.getModality().isOverridable();
    }

    public static boolean isBuiltin(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "isBuiltin"));
        }
        PackageFragmentDescriptor containingPackageFragment = DescriptorUtils.getParentOfType(descriptor, PackageFragmentDescriptor.class);
        return containingPackageFragment == KotlinBuiltIns.getInstance().getBuiltInsPackageFragment();
    }

    @Nullable
    public static Name getNameIfStandardType(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getNameIfStandardType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getNameIfStandardType"));
        }
        JetType type = context.bindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
        return type != null ? JsDescriptorUtils.getNameIfStandardType(type) : null;
    }

    @Nullable
    public static Name getNameIfStandardType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/k2js/translate/utils/JsDescriptorUtils", "getNameIfStandardType"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && descriptor.getContainingDeclaration() == KotlinBuiltIns.getInstance().getBuiltInsPackageFragment()) {
            return descriptor.getName();
        }
        return null;
    }
}

