/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class CompareToTranslator
extends AbstractTranslator {
    @NotNull
    private final JetBinaryExpression expression;

    public static boolean isCompareToCall(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "isCompareToCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "isCompareToCall"));
        }
        FunctionDescriptor operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null) {
            return false;
        }
        return JsDescriptorUtils.isCompareTo(operationDescriptor);
    }

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "translate"));
        }
        JsExpression jsExpression = new CompareToTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "translate"));
        }
        return jsExpression;
    }

    private CompareToTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null) : "CompareTo should always have a descriptor";
        assert (OperatorConventions.COMPARISON_OPERATIONS.contains(PsiUtils.getOperationToken(expression)));
    }

    @NotNull
    private JsExpression translate() {
        JsBinaryOperator correspondingOperator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression methodCall = BinaryOperationTranslator.translateAsOverloadedCall(this.expression, this.context());
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(correspondingOperator, methodCall, this.context().program().getNumberLiteral(0));
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/CompareToTranslator", "translate"));
        }
        return jsBinaryOperation;
    }
}

