/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.context.UsageTracker;

abstract class InnerDeclarationTranslator {
    protected final TranslationContext context;
    protected final JsFunction fun;

    public InnerDeclarationTranslator(@NotNull TranslationContext context, @NotNull JsFunction fun) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "<init>"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "<init>"));
        }
        this.context = context;
        this.fun = fun;
    }

    @NotNull
    public JsExpression translate(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "translate"));
        }
        UsageTracker usageTracker = this.context.usageTracker();
        assert (usageTracker != null) : "Usage tracker should not be null for InnerDeclarationTranslator";
        boolean hasCaptured = usageTracker.hasCaptured();
        if (!hasCaptured && self == JsLiteral.NULL) {
            JsExpression jsExpression = this.createExpression(nameRef, self);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "translate"));
            }
            return jsExpression;
        }
        JsInvocation invocation = this.createInvocation(nameRef, self);
        if (hasCaptured) {
            final List<JsExpression> invocationArguments = invocation.getArguments();
            usageTracker.forEachCaptured(new Consumer<CallableDescriptor>(){

                @Override
                public void consume(CallableDescriptor descriptor) {
                    InnerDeclarationTranslator.this.fun.getParameters().add(new JsParameter(InnerDeclarationTranslator.this.getParameterNameFor(descriptor)));
                    invocationArguments.add(InnerDeclarationTranslator.this.getParameterNameRefFor(descriptor));
                }
            });
        }
        JsInvocation jsInvocation = invocation;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "translate"));
        }
        return jsInvocation;
    }

    @NotNull
    protected JsName getParameterNameFor(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "getParameterNameFor"));
        }
        JsName jsName = this.context.getNameForDescriptor(descriptor);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "getParameterNameFor"));
        }
        return jsName;
    }

    @NotNull
    protected JsNameRef getParameterNameRefFor(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "getParameterNameRefFor"));
        }
        JsNameRef jsNameRef = this.getParameterNameFor(descriptor).makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/InnerDeclarationTranslator", "getParameterNameRefFor"));
        }
        return jsNameRef;
    }

    @NotNull
    protected abstract JsExpression createExpression(@NotNull JsNameRef var1, @Nullable JsExpression var2);

    @NotNull
    protected abstract JsInvocation createInvocation(@NotNull JsNameRef var1, @Nullable JsExpression var2);
}

