/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String CALLEE_NAME = "$fun";
    public static final String OUTER_CLASS_NAME = "$outer";
    @NotNull
    private final JsName kotlinName;
    @NotNull
    private final JsScope kotlinScope;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsName traitName;
    @NotNull
    private final JsExpression definePackage;
    @NotNull
    private final JsExpression defineRootPackage;
    @NotNull
    private final JsName objectName;
    @NotNull
    private final JsName enumEntriesName;
    @NotNull
    private final JsExpression undefinedExpression;
    @NotNull
    private final JsExpression callGetProperty;
    @NotNull
    private final JsExpression callSetProperty;
    @NotNull
    private final JsName isTypeName;

    @NotNull
    public static String getReceiverParameterName() {
        if ("$receiver" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getReceiverParameterName"));
        }
        return "$receiver";
    }

    @NotNull
    public static String getRootPackageName() {
        if ("_" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getRootPackageName"));
        }
        return "_";
    }

    @NotNull
    public static JsNameRef superMethodNameRef(@NotNull JsName superClassJsName) {
        if (superClassJsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassJsName", "org/jetbrains/k2js/translate/context/Namer", "superMethodNameRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("baseInitializer", (JsExpression)superClassJsName.makeRef());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "superMethodNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getNameForAccessor(@NotNull String propertyName, boolean isGetter, boolean useNativeAccessor) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
        }
        if (useNativeAccessor) {
            String string = propertyName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        if (isGetter) {
            String string = Namer.getNameForGetter(propertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        String string = Namer.getNameForSetter(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
        }
        return string;
    }

    @NotNull
    public static String getKotlinBackingFieldName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/k2js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "$");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        return string;
    }

    @NotNull
    private static String getNameForGetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/k2js/translate/context/Namer", "getNameForGetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "get_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForGetter"));
        }
        return string;
    }

    @NotNull
    private static String getNameForSetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/k2js/translate/context/Namer", "getNameForSetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "set_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForSetter"));
        }
        return string;
    }

    @NotNull
    public static JsExpression getClassObjectAccessor(@NotNull JsExpression referenceToClass) {
        if (referenceToClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceToClass", "org/jetbrains/k2js/translate/context/Namer", "getClassObjectAccessor"));
        }
        JsNameRef jsNameRef = new JsNameRef("object", referenceToClass);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getClassObjectAccessor"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getNameForClassObjectInitializer() {
        if ("object_initializer$" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForClassObjectInitializer"));
        }
        return "object_initializer$";
    }

    @NotNull
    public static String getPrototypeName() {
        if ("prototype" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getPrototypeName"));
        }
        return "prototype";
    }

    @NotNull
    public static JsNameRef getRefToPrototype(@NotNull JsExpression classOrTraitExpression) {
        if (classOrTraitExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrTraitExpression", "org/jetbrains/k2js/translate/context/Namer", "getRefToPrototype"));
        }
        JsNameRef jsNameRef = new JsNameRef(Namer.getPrototypeName(), classOrTraitExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getRefToPrototype"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getDelegateName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/k2js/translate/context/Namer", "getDelegateName"));
        }
        String string = propertyName + "$delegate";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getDelegateName"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getDelegateNameRef(String propertyName) {
        JsNameRef jsNameRef = new JsNameRef(Namer.getDelegateName(propertyName), (JsExpression)JsLiteral.THIS);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getDelegateNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private static String getNameWithPrefix(@NotNull String name, @NotNull String prefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/translate/context/Namer", "getNameWithPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/k2js/translate/context/Namer", "getNameWithPrefix"));
        }
        String string = prefix + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameWithPrefix"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/k2js/translate/context/Namer", "getFunctionCallRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("call", functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getFunctionCallRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef getFunctionApplyRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/k2js/translate/context/Namer", "getFunctionApplyRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("apply", functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getFunctionApplyRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/k2js/translate/context/Namer", "newInstance"));
        }
        Namer namer = new Namer(rootScope);
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "newInstance"));
        }
        return namer;
    }

    private Namer(@NotNull JsScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/k2js/translate/context/Namer", "<init>"));
        }
        this.kotlinName = rootScope.declareName(KOTLIN_NAME);
        this.kotlinScope = new JsScope(rootScope, "Kotlin standard object");
        this.traitName = this.kotlinScope.declareName("createTrait");
        this.definePackage = this.kotlin("definePackage");
        this.defineRootPackage = this.kotlin("defineRootPackage");
        this.callGetProperty = this.kotlin("callGetter");
        this.callSetProperty = this.kotlin("callSetter");
        this.className = this.kotlinScope.declareName("createClass");
        this.enumEntriesName = this.kotlinScope.declareName("createEnumEntries");
        this.objectName = this.kotlinScope.declareName("createObject");
        this.isTypeName = this.kotlinScope.declareName("isType");
        this.undefinedExpression = new JsPrefixOperation(JsUnaryOperator.VOID, rootScope.getProgram().getNumberLiteral(0));
    }

    @NotNull
    public JsExpression classCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.className);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression enumEntriesCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.enumEntriesName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "enumEntriesCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression traitCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.traitName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "traitCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression packageDefinitionMethodReference() {
        JsExpression jsExpression = this.definePackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "packageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression rootPackageDefinitionMethodReference() {
        JsExpression jsExpression = this.defineRootPackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "rootPackageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression objectCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.objectName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "objectCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression throwNPEFunctionRef() {
        JsNameRef jsNameRef = new JsNameRef("throwNPE", (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "throwNPEFunctionRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsNameRef kotlin(@NotNull JsName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = new JsNameRef(name, (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression kotlin(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = this.kotlin(this.kotlinScope.declareName(name));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef kotlinObject() {
        JsNameRef jsNameRef = this.kotlinName.makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "kotlinObject"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isOperationReference() {
        JsNameRef jsNameRef = this.kotlin(this.isTypeName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "isOperationReference"));
        }
        return jsNameRef;
    }

    @NotNull
    JsScope getKotlinScope() {
        JsScope jsScope = this.kotlinScope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getKotlinScope"));
        }
        return jsScope;
    }

    @NotNull
    static String generatePackageName(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/k2js/translate/context/Namer", "generatePackageName"));
        }
        String string = packageFqName.isRoot() ? Namer.getRootPackageName() : packageFqName.shortName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "generatePackageName"));
        }
        return string;
    }

    @NotNull
    public JsExpression classCreateInvocation(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
        }
        ClassKind kind = descriptor.getKind();
        if (kind == ClassKind.TRAIT) {
            JsExpression jsExpression = this.traitCreationMethodReference();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
            }
            return jsExpression;
        }
        if (kind.isSingleton() || DescriptorUtils.isAnonymousObject(descriptor)) {
            JsExpression jsExpression = this.objectCreationMethodReference();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.classCreationMethodReference();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
        }
        return jsExpression;
    }

    @NotNull
    public JsInvocation enumEntriesObjectCreateInvocation() {
        JsInvocation jsInvocation = new JsInvocation(this.enumEntriesCreationMethodReference());
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "enumEntriesObjectCreateInvocation"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsExpression getUndefinedExpression() {
        JsExpression jsExpression = this.undefinedExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getUndefinedExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallGetProperty() {
        JsExpression jsExpression = this.callGetProperty;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getCallGetProperty"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallSetProperty() {
        JsExpression jsExpression = this.callSetProperty;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getCallSetProperty"));
        }
        return jsExpression;
    }
}

