/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.utils.JetFileUtils;

public class LibrarySourcesConfig
extends Config {
    @NotNull
    public static final Key<String> EXTERNAL_MODULE_NAME = Key.create("externalModule");
    @NotNull
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    @NotNull
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.k2js.config.LibrarySourcesConfig");
    @NotNull
    private final List<String> files;

    public LibrarySourcesConfig(@NotNull Project project, @NotNull String moduleId, @NotNull List<String> files, @NotNull EcmaVersion ecmaVersion, boolean sourcemap) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        super(project, moduleId, ecmaVersion, sourcemap);
        this.files = files;
    }

    @Override
    @NotNull
    protected List<JetFile> generateLibFiles() {
        if (this.files.isEmpty()) {
            List<JetFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfig", "generateLibFiles"));
            }
            return list;
        }
        ArrayList<JetFile> jetFiles = new ArrayList<JetFile>();
        String moduleName = UNKNOWN_EXTERNAL_MODULE_NAME;
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        PsiManager psiManager = PsiManager.getInstance(this.getProject());
        for (String path : this.files) {
            if (path.charAt(0) == '@') {
                moduleName = path.substring(1);
                continue;
            }
            if (path.endsWith(".jar") || path.endsWith(".zip")) {
                try {
                    jetFiles.addAll(this.readZip(path));
                }
                catch (IOException e) {
                    LOG.error(e);
                }
                continue;
            }
            VirtualFile file = fileSystem.findFileByPath(path);
            if (file == null) {
                LOG.error("File '" + path + "not found.'");
                continue;
            }
            if (file.isDirectory()) {
                JetFileCollector jetFileCollector = new JetFileCollector(jetFiles, moduleName, psiManager);
                VfsUtilCore.visitChildrenRecursively(file, jetFileCollector);
                continue;
            }
            jetFiles.add(LibrarySourcesConfig.getJetFileByVirtualFile(file, moduleName, psiManager));
        }
        ArrayList<JetFile> arrayList = jetFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfig", "generateLibFiles"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JetFile> readZip(String file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            List<JetFile> list = this.traverseArchive(zipFile);
            return list;
        }
        finally {
            zipFile.close();
        }
    }

    @NotNull
    private List<JetFile> traverseArchive(@NotNull ZipFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/k2js/config/LibrarySourcesConfig", "traverseArchive"));
        }
        ArrayList<JetFile> result = Lists.newArrayList();
        Enumeration<? extends ZipEntry> zipEntries = file.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".kt")) continue;
            InputStream stream = file.getInputStream(entry);
            String text = FileUtil.loadTextAndClose(stream);
            JetFile jetFile = JetFileUtils.createJetFile(entry.getName(), text, this.getProject());
            jetFile.putUserData(EXTERNAL_MODULE_NAME, UNKNOWN_EXTERNAL_MODULE_NAME);
            result.add(jetFile);
        }
        ArrayList<JetFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfig", "traverseArchive"));
        }
        return arrayList;
    }

    private static JetFile getJetFileByVirtualFile(VirtualFile file, String moduleName, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(file);
        assert (psiFile != null);
        psiFile.putUserData(EXTERNAL_MODULE_NAME, moduleName);
        return (JetFile)psiFile;
    }

    private static class JetFileCollector
    extends VirtualFileVisitor {
        private final List<JetFile> jetFiles;
        private final String moduleName;
        private final PsiManager psiManager;

        private JetFileCollector(List<JetFile> files, String name, PsiManager manager) {
            super(new VirtualFileVisitor.Option[0]);
            this.moduleName = name;
            this.psiManager = manager;
            this.jetFiles = files;
        }

        @Override
        public boolean visitFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/k2js/config/LibrarySourcesConfig$JetFileCollector", "visitFile"));
            }
            if (file.getName().endsWith(".kt")) {
                this.jetFiles.add(LibrarySourcesConfig.getJetFileByVirtualFile(file, this.moduleName, this.psiManager));
                return false;
            }
            return true;
        }
    }
}

