/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    public static final String RETURN_NOT_ALLOWED_MESSAGE = "Return not allowed";

    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@NotNull JetScope scope, @Nullable JetExpression condition, ExpressionTypingContext context) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        if (condition != null) {
            JetTypeInfo typeInfo = this.facade.getTypeInfo(condition, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope)).replaceExpectedType(KotlinBuiltIns.getInstance().getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT));
            JetType conditionType = typeInfo.getType();
            if (conditionType != null && !ExpressionTypingUtils.isBoolean(conditionType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(condition, conditionType));
            }
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        return dataFlowInfo;
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitIfExpression"));
        }
        return this.visitIfExpression(expression, context, false);
    }

    public JetTypeInfo visitIfExpression(JetIfExpression ifExpression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        boolean jumpInElse;
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = ifExpression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(context.scope, condition, context);
        JetExpression elseBranch = ifExpression.getElse();
        JetExpression thenBranch = ifExpression.getThen();
        WritableScopeImpl thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Then scope");
        WritableScopeImpl elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Else scope");
        DataFlowInfo thenInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, context).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                return this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, contextWithExpectedType, ifExpression, isStatement);
            }
            return DataFlowUtils.checkImplicitCast(KotlinBuiltIns.getInstance().getUnitType(), ifExpression, contextWithExpectedType, isStatement, thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, contextWithExpectedType, ifExpression, isStatement);
        }
        JetBlockExpression thenBlock = JetPsiFactory.wrapInABlock(thenBranch);
        JetBlockExpression elseBlock = JetPsiFactory.wrapInABlock(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression, Lists.newArrayList(thenBlock, elseBlock));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, "If", Lists.newArrayList("thenBranch", "elseBranch"), Lists.newArrayList(false, false), contextWithExpectedType, dataFlowInfoForArguments);
        JetTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, context.trace.getBindingContext());
        JetTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, context.trace.getBindingContext());
        assert (thenTypeInfo != null) : "'Then' branch of if expression  was not processed: " + ifExpression;
        assert (elseTypeInfo != null) : "'Else' branch of if expression  was not processed: " + ifExpression;
        JetType thenType = thenTypeInfo.getType();
        JetType elseType = elseTypeInfo.getType();
        DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        boolean jumpInThen = thenType != null && KotlinBuiltIns.getInstance().isNothing(thenType);
        boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.getInstance().isNothing(elseType);
        JetTypeInfo result = thenType == null && elseType == null ? JetTypeInfo.create(null, thenDataFlowInfo.or(elseDataFlowInfo)) : (thenType == null || jumpInThen && !jumpInElse ? elseTypeInfo : (elseType == null || jumpInElse && !jumpInThen ? thenTypeInfo : JetTypeInfo.create(resolvedCall.getResultingDescriptor().getReturnType(), thenDataFlowInfo.or(elseDataFlowInfo))));
        return DataFlowUtils.checkImplicitCast(result.getType(), ifExpression, contextWithExpectedType, isStatement, result.getDataFlowInfo());
    }

    @NotNull
    private JetTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull JetExpression presentBranch, @NotNull WritableScopeImpl presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context, @NotNull JetIfExpression ifExpression, boolean isStatement) {
        if (presentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentBranch", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentScope", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentInfo", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext, context.trace);
        JetType type = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type != null && KotlinBuiltIns.getInstance().isNothing(type) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        JetType typeForIfExpression = DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), (JetExpression)ifExpression, (ResolutionContext)context);
        JetTypeInfo jetTypeInfo = DataFlowUtils.checkImplicitCast(typeForIfExpression, ifExpression, context, isStatement, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitWhileExpression"));
        }
        return this.visitWhileExpression(expression, context, false);
    }

    public JetTypeInfo visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression condition = expression.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(context.scope, condition, context);
        JetExpression body = expression.getBody();
        if (body != null) {
            WritableScopeImpl scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in while's condition");
            DataFlowInfo conditionInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, context).and(dataFlowInfo);
            this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(conditionInfo), context.trace);
        }
        if (!this.containsJumpOutOfLoop(expression, context)) {
            dataFlowInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context).and(dataFlowInfo);
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final JetLoopExpression loopExpression, final ExpressionTypingContext context) {
        final boolean[] result = new boolean[]{false};
        loopExpression.accept(new JetTreeVisitor<List<JetLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull JetBreakExpression breakExpression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                if (breakExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakExpression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor$1", "visitBreakExpression"));
                }
                JetSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement = element = targetLabel != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (element == loopExpression || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == loopExpression) {
                    result[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull JetContinueExpression expression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor$1", "visitContinueExpression"));
                }
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                if (targetLabel != null && (element = context.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof JetLoopExpression && !outerLoops.contains(element)) {
                    result[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull JetLoopExpression loopExpression2, List<JetLoopExpression> outerLoops) {
                if (loopExpression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExpression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor$1", "visitLoopExpression"));
                }
                ArrayList<JetLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression2);
                return (Void)super.visitLoopExpression(loopExpression2, newOuterLoops);
            }
        }, Lists.newArrayList(loopExpression));
        return result[0];
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitDoWhileExpression"));
        }
        return this.visitDoWhileExpression(expression, context, false);
    }

    public JetTypeInfo visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression body = expression.getBody();
        JetScope conditionScope = context.scope;
        if (body instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression function = (JetFunctionLiteralExpression)body;
            JetFunctionLiteral functionLiteral = function.getFunctionLiteral();
            if (!functionLiteral.hasParameterSpecification()) {
                WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
                conditionScope = writableScope;
                this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, functionLiteral.getBodyExpression().getStatements(), CoercionStrategy.NO_COERCION, context, context.trace);
                context.trace.record(BindingContext.BLOCK, function);
            } else {
                this.facade.getTypeInfo(body, (ExpressionTypingContext)context.replaceScope(context.scope));
            }
            context.trace.report(Errors.UNUSED_FUNCTION_LITERAL.on(function));
        } else if (body != null) {
            WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
            conditionScope = writableScope;
            List<JetElement> block = body instanceof JetBlockExpression ? ((JetBlockExpression)body).getStatements() : Collections.singletonList(body);
            this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context, context.trace);
        }
        JetExpression condition = expression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(conditionScope, condition, context);
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression, context) ? DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo) : context.dataFlowInfo;
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitForExpression"));
        }
        return this.visitForExpression(expression, context, false);
    }

    public JetTypeInfo visitForExpression(JetForExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression loopRange = expression.getLoopRange();
        JetType expectedParameterType = null;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, (ExpressionTypingContext)context.replaceScope(context.scope));
            dataFlowInfo = this.facade.getTypeInfo(loopRange, context).getDataFlowInfo();
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context);
            }
        }
        WritableScopeImpl loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope with for-loop index");
        JetParameter loopParameter = expression.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context);
            loopScope.addVariableDescriptor(variableDescriptor);
        } else {
            JetMultiDeclaration multiParameter = expression.getMultiParameter();
            if (multiParameter != null && loopRange != null) {
                JetType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.expressionTypingUtils.defineLocalVariablesFromMultiDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context);
            }
        }
        JetExpression body = expression.getBody();
        if (body != null) {
            this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo), context.trace);
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    private VariableDescriptor createLoopParameterDescriptor(JetParameter loopParameter, JetType expectedParameterType, ExpressionTypingContext context) {
        VariableDescriptor variableDescriptor;
        DescriptorResolver.checkParameterHasNoValOrVar(context.trace, loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        JetTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope, loopParameter, context.trace);
            JetType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context.trace, context.scope);
        }
        VariableDescriptor olderVariable = context.scope.getLocalVariable(variableDescriptor.getName());
        if (olderVariable != null && DescriptorUtils.isLocal(context.scope.getContainingDeclaration(), olderVariable)) {
            PsiElement declaration = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), variableDescriptor);
            context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
        return variableDescriptor;
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression, ExpressionTypingContext typingContext) {
        JetType type;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitTryExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        JetBlockExpression tryBlock = expression.getTryBlock();
        List<JetCatchClause> catchClauses = expression.getCatchClauses();
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        ArrayList<JetType> types = new ArrayList<JetType>();
        for (JetCatchClause catchClause : catchClauses) {
            JetParameter catchParameter = catchClause.getCatchParameter();
            JetExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            DescriptorResolver.checkParameterHasNoValOrVar(context.trace, catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
            DescriptorResolver.checkParameterHasNoModifier(context.trace, catchParameter);
            VariableDescriptor variableDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope, catchParameter, context.trace);
            JetType throwableType = KotlinBuiltIns.getInstance().getThrowable().getDefaultType();
            DataFlowUtils.checkType(variableDescriptor.getType(), (JetExpression)catchParameter, context.replaceExpectedType(throwableType));
            if (catchBody == null) continue;
            WritableScopeImpl catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Catch scope");
            catchScope.addVariableDescriptor(variableDescriptor);
            JetType type2 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context.replaceScope(catchScope)).getType();
            if (type2 == null) continue;
            types.add(type2);
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (finallyBlock != null) {
            dataFlowInfo = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).getDataFlowInfo();
        }
        if ((type = this.facade.getTypeInfo(tryBlock, context).getType()) != null) {
            types.add(type);
        }
        if (types.isEmpty()) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        return JetTypeInfo.create(CommonSupertypes.commonSupertype(types), dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitThrowExpression"));
        }
        JetExpression thrownExpression = expression.getThrownExpression();
        if (thrownExpression != null) {
            JetType throwableType = KotlinBuiltIns.getInstance().getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(throwableType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitReturnExpression"));
        }
        JetElement labelTargetElement = context.labelResolver.resolveLabel(expression, context);
        JetExpression returnedExpression = expression.getReturnedExpression();
        JetType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        JetType resultType = KotlinBuiltIns.getInstance().getNothingType();
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration instanceof JetParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
        }
        assert (parentDeclaration != null);
        DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (expression.getTargetLabel() == null) {
            if (containingFunctionDescriptor != null) {
                PsiElement containingFunction = BindingContextUtils.callableDescriptorToDeclaration(context.trace.getBindingContext(), containingFunctionDescriptor);
                assert (containingFunction != null);
                if (containingFunction instanceof JetFunctionLiteral) {
                    while ((containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? BindingContextUtils.callableDescriptorToDeclaration(context.trace.getBindingContext(), containingFunctionDescriptor) : null) instanceof JetFunctionLiteral) {
                    }
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
                if (containingFunctionDescriptor != null) {
                    expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (JetElement)containingFunction);
                }
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
            }
        } else if (labelTargetElement != null) {
            SimpleFunctionDescriptor functionDescriptor = context.trace.get(BindingContext.FUNCTION, labelTargetElement);
            if (functionDescriptor != null) {
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement);
                if (functionDescriptor != containingFunctionDescriptor) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                } else if (expectedType == TypeUtils.NO_EXPECTED_TYPE) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED_EXPLICIT_RETURN_TYPE_REQUIRED.on(expression));
                }
            } else {
                context.trace.report(Errors.NOT_A_RETURN_LABEL.on(expression, expression.getLabelName()));
            }
        }
        if (returnedExpression != null) {
            this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        } else if (expectedType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinBuiltIns.getInstance().isUnit(expectedType)) {
            context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression, expectedType));
        }
        return DataFlowUtils.checkType(resultType, expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitBreakExpression"));
        }
        context.labelResolver.resolveLabel(expression, context);
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "visitContinueExpression"));
        }
        context.labelResolver.resolveLabel(expression, context);
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getNothingType(), expression, context, context.dataFlowInfo);
    }

    @NotNull
    private static JetType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor, @NotNull JetElement function) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        JetType expectedType = function instanceof JetFunction ? (((JetFunction)function).getReturnTypeRef() != null || ((JetFunction)function).hasBlockBody() ? descriptor.getReturnType() : TypeUtils.NO_EXPECTED_TYPE) : descriptor.getReturnType();
        JetType jetType = expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        return jetType;
    }
}

