/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.LazyType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.util.ReenteringLazyValueComputationException;

public class DeferredType
implements LazyType {
    private static final Function1 EMPTY_CONSUMER = new Function1<Object, Void>(){

        @Override
        public Void invoke(Object t) {
            return null;
        }
    };
    private static final Function1<Boolean, JetType> RECURSION_PREVENTER = new Function1<Boolean, JetType>(){

        @Override
        public JetType invoke(Boolean firstTime) {
            if (firstTime.booleanValue()) {
                throw new ReenteringLazyValueComputationException();
            }
            return ErrorUtils.createErrorType("Recursive dependency");
        }
    };
    private final NotNullLazyValue<JetType> lazyValue;

    @NotNull
    public static DeferredType create(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<JetType> compute) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/DeferredType", "create"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/DeferredType", "create"));
        }
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/lang/types/DeferredType", "create"));
        }
        DeferredType deferredType = new DeferredType(storageManager.createLazyValue(compute));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        DeferredType deferredType2 = deferredType;
        if (deferredType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "create"));
        }
        return deferredType2;
    }

    @NotNull
    public static DeferredType createRecursionIntolerant(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<JetType> compute) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/DeferredType", "createRecursionIntolerant"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/DeferredType", "createRecursionIntolerant"));
        }
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/lang/types/DeferredType", "createRecursionIntolerant"));
        }
        DeferredType deferredType = new DeferredType(storageManager.createLazyValueWithPostCompute(compute, RECURSION_PREVENTER, EMPTY_CONSUMER));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        DeferredType deferredType2 = deferredType;
        if (deferredType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "createRecursionIntolerant"));
        }
        return deferredType2;
    }

    private DeferredType(@NotNull NotNullLazyValue<JetType> lazyValue) {
        if (lazyValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyValue", "org/jetbrains/jet/lang/types/DeferredType", "<init>"));
        }
        this.lazyValue = lazyValue;
    }

    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    @NotNull
    public JetType getActualType() {
        JetType jetType = (JetType)this.lazyValue.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getActualType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.getActualType().getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return this.getActualType().isError();
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor = this.getActualType().getConstructor();
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.getActualType().getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isNullable() {
        return this.getActualType().isNullable();
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations = this.getActualType().getAnnotations();
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DeferredType", "getAnnotations"));
        }
        return annotations;
    }

    public String toString() {
        try {
            if (this.lazyValue.isComputed()) {
                return this.getActualType().toString();
            }
            return "<Not computed yet>";
        }
        catch (ReenteringLazyValueComputationException e) {
            return "<Failed to compute this type>";
        }
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.getActualType()).equals(obj);
    }

    public int hashCode() {
        return this.getActualType().hashCode();
    }
}

