/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ClassObjectMixinScope
extends AbstractScopeAdapter {
    private final ClassDescriptor classObjectDescriptor;

    public ClassObjectMixinScope(ClassDescriptor classObjectDescriptor) {
        this.classObjectDescriptor = classObjectDescriptor;
    }

    @Override
    @NotNull
    protected JetScope getWorkerScope() {
        JetScope jetScope = this.classObjectDescriptor.getDefaultType().getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ClassObjectMixinScope", "getWorkerScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list = Collections.singletonList(this.classObjectDescriptor.getThisAsReceiverParameter());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/ClassObjectMixinScope", "getImplicitReceiversHierarchy"));
        }
        return list;
    }
}

