/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class LazyPackageMemberScope
extends AbstractLazyMemberScope<PackageFragmentDescriptor, PackageMemberDeclarationProvider> {
    public LazyPackageMemberScope(@NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider, @NotNull PackageFragmentDescriptor thisPackage) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "<init>"));
        }
        if (thisPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisPackage", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "<init>"));
        }
        super(resolveSession, declarationProvider, thisPackage);
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getPackage"));
        }
        return null;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getClassifier"));
        }
        Name actualName = this.resolveSession.resolveClassifierAlias(DescriptorUtils.getFqNameSafe(this.thisDescriptor), name);
        return super.getClassifier(actualName);
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        JetScope jetScope = this.resolveSession.getScopeProvider().getFileScope((JetFile)declaration.getContainingFile());
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getScopeForMemberDeclarationResolution"));
        }
        return jetScope;
    }

    @Override
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<FunctionDescriptor> result) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredFunctions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredFunctions"));
        }
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredProperties"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "getNonDeclaredProperties"));
        }
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeExtraDescriptors() {
        List<DeclarationDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageMemberScope", "computeExtraDescriptors"));
        }
        return list;
    }

    @Override
    public String toString() {
        return "lazy scope for package " + ((PackageFragmentDescriptor)this.thisDescriptor).getName();
    }
}

