/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.header;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KotlinClassHeader {
    private final Kind kind;
    private final int version;
    private final String[] data;

    public KotlinClassHeader(@NotNull Kind kind, int version, @Nullable String[] annotationData) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/header/KotlinClassHeader", "<init>"));
        }
        assert (annotationData == null == (kind != Kind.CLASS && kind != Kind.PACKAGE_FACADE)) : "Annotation data should be not null only for CLASS and PACKAGE_FACADE";
        this.kind = kind;
        this.version = version;
        this.data = annotationData;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.kind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/KotlinClassHeader", "getKind"));
        }
        return kind;
    }

    public int getVersion() {
        return this.version;
    }

    @Nullable
    public String[] getAnnotationData() {
        return this.data;
    }

    public static enum Kind {
        CLASS,
        PACKAGE_FACADE,
        SYNTHETIC_CLASS,
        INCOMPATIBLE_ABI_VERSION;

    }
}

