/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.java.lazy.LazyJavaPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;

public class JavaDescriptorResolver
implements DependencyClassByQualifiedNameResolver {
    public static final Name JAVA_ROOT = Name.special("<java_root>");
    private final ModuleDescriptor module;
    private final LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider;

    public JavaDescriptorResolver(@NotNull LazyJavaPackageFragmentProvider provider, @NotNull ModuleDescriptor module) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/jet/lang/resolve/java/JavaDescriptorResolver", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/java/JavaDescriptorResolver", "<init>"));
        }
        this.lazyJavaPackageFragmentProvider = provider;
        this.module = module;
    }

    @NotNull
    public ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaDescriptorResolver", "getModule"));
        }
        return moduleDescriptor;
    }

    @NotNull
    public PackageFragmentProvider getPackageFragmentProvider() {
        LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider = this.lazyJavaPackageFragmentProvider;
        if (lazyJavaPackageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaDescriptorResolver", "getPackageFragmentProvider"));
        }
        return lazyJavaPackageFragmentProvider;
    }

    @Override
    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/JavaDescriptorResolver", "resolveClass"));
        }
        return this.lazyJavaPackageFragmentProvider.getClass(qualifiedName);
    }

    @Nullable
    public PackageFragmentDescriptor getPackageFragment(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/JavaDescriptorResolver", "getPackageFragment"));
        }
        return this.lazyJavaPackageFragmentProvider.getPackageFragment(fqName);
    }
}

