/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DeclarationResolver {
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptHeaderResolver scriptHeaderResolver;
    @NotNull
    private BindingTrace trace;

    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        if (importsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setImportsResolver"));
        }
        this.importsResolver = importsResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void setScriptHeaderResolver(@NotNull ScriptHeaderResolver scriptHeaderResolver) {
        if (scriptHeaderResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptHeaderResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setScriptHeaderResolver"));
        }
        this.scriptHeaderResolver = scriptHeaderResolver;
    }

    public void process(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "process"));
        }
        this.checkModifiersAndAnnotationsInPackageDirectives(c);
        this.resolveAnnotationConstructors(c);
        this.resolveConstructorHeaders(c);
        this.resolveAnnotationStubsOnClassesAndConstructors(c);
        this.resolveFunctionAndPropertyHeaders(c);
        this.createFunctionsForDataClasses(c);
        this.importsResolver.processMembersImports(c);
        this.checkRedeclarationsInPackages(c);
        this.checkRedeclarationsInInnerClassNames(c);
    }

    private void checkModifiersAndAnnotationsInPackageDirectives(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkModifiersAndAnnotationsInPackageDirectives"));
        }
        for (JetFile file : c.getPackageFragments().keySet()) {
            PsiElement firstChild;
            JetPackageDirective packageDirective = file.getPackageDirective();
            if (packageDirective == null || !((firstChild = packageDirective.getFirstChild()) instanceof JetModifierList)) continue;
            JetModifierList modifierList = (JetModifierList)firstChild;
            for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
                JetReferenceExpression reference;
                JetConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
                if (calleeExpression == null || (reference = calleeExpression.getConstructorReferenceExpression()) == null) continue;
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
            }
            for (ASTNode node : modifierList.getModifierNodes()) {
                this.trace.report(Errors.ILLEGAL_MODIFIER.on(node.getPsi(), (JetKeywordToken)node.getElementType()));
            }
        }
    }

    private void resolveAnnotationConstructors(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveAnnotationConstructors"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            if (!(classOrObject instanceof JetClass) || !DescriptorUtils.isAnnotationClass(classDescriptor)) continue;
            this.processPrimaryConstructor(c, classDescriptor, (JetClass)classOrObject);
        }
    }

    private void resolveConstructorHeaders(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveConstructorHeaders"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            if (!(classOrObject instanceof JetClass) || DescriptorUtils.isAnnotationClass(classDescriptor)) continue;
            this.processPrimaryConstructor(c, classDescriptor, (JetClass)classOrObject);
        }
    }

    private void resolveAnnotationStubsOnClassesAndConstructors(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveAnnotationStubsOnClassesAndConstructors"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            JetModifierList modifierList = entry.getKey().getModifierList();
            if (modifierList == null) continue;
            MutableClassDescriptor descriptor = (MutableClassDescriptor)entry.getValue();
            descriptor.addAnnotations(this.annotationResolver.resolveAnnotationsWithoutArguments(descriptor.getScopeForClassHeaderResolution(), modifierList, this.trace));
        }
    }

    private void resolveFunctionAndPropertyHeaders(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        for (Map.Entry<JetFile, WritableScope> entry : c.getFileScopes().entrySet()) {
            JetFile file = entry.getKey();
            WritableScope fileScope = entry.getValue();
            PackageLikeBuilder packageBuilder = c.getPackageFragments().get(file).getBuilder();
            this.resolveFunctionAndPropertyHeaders(c, file.getDeclarations(), fileScope, fileScope, fileScope, packageBuilder);
        }
        for (Map.Entry<JetElement, Object> entry : c.getClasses().entrySet()) {
            JetClassOrObject classOrObject = (JetClassOrObject)entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            JetClassBody jetClassBody = classOrObject.getBody();
            if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS && jetClassBody != null) {
                this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(jetClassBody));
            }
            this.resolveFunctionAndPropertyHeaders(c, classOrObject.getDeclarations(), classDescriptor.getScopeForMemberDeclarationResolution(), classDescriptor.getScopeForInitializerResolution(), classDescriptor.getScopeForMemberDeclarationResolution(), classDescriptor.getBuilder());
        }
        this.scriptHeaderResolver.resolveScriptDeclarations(c);
    }

    private void resolveFunctionAndPropertyHeaders(final @NotNull TopDownAnalysisContext c, @NotNull List<JetDeclaration> declarations, final @NotNull JetScope scopeForFunctions, final @NotNull JetScope scopeForPropertyInitializers, final @NotNull JetScope scopeForPropertyAccessors, final @NotNull PackageLikeBuilder packageLike) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForFunctions", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForPropertyInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForPropertyInitializers", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForPropertyAccessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForPropertyAccessors", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (packageLike == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageLike", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        for (JetDeclaration declaration : declarations) {
            declaration.accept(new JetVisitorVoid(){

                @Override
                public void visitNamedFunction(@NotNull JetNamedFunction function) {
                    if (function == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DeclarationResolver$1", "visitNamedFunction"));
                    }
                    SimpleFunctionDescriptor functionDescriptor = DeclarationResolver.this.descriptorResolver.resolveFunctionDescriptor(packageLike.getOwnerForChildren(), scopeForFunctions, function, DeclarationResolver.this.trace, c.getOuterDataFlowInfo());
                    packageLike.addFunctionDescriptor(functionDescriptor);
                    c.getFunctions().put(function, functionDescriptor);
                    c.registerDeclaringScope(function, scopeForFunctions);
                }

                @Override
                public void visitProperty(@NotNull JetProperty property2) {
                    JetPropertyAccessor setter;
                    if (property2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DeclarationResolver$1", "visitProperty"));
                    }
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolvePropertyDescriptor(packageLike.getOwnerForChildren(), scopeForPropertyInitializers, property2, DeclarationResolver.this.trace, c.getOuterDataFlowInfo());
                    packageLike.addPropertyDescriptor(propertyDescriptor);
                    c.getProperties().put(property2, propertyDescriptor);
                    c.registerDeclaringScope(property2, scopeForPropertyInitializers);
                    JetPropertyAccessor getter = property2.getGetter();
                    if (getter != null) {
                        c.registerDeclaringScope(getter, scopeForPropertyAccessors);
                    }
                    if ((setter = property2.getSetter()) != null) {
                        c.registerDeclaringScope(setter, scopeForPropertyAccessors);
                    }
                }
            });
        }
    }

    private void createFunctionsForDataClasses(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createFunctionsForDataClasses"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            JetClassOrObject klass = entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            if (!(klass instanceof JetClass) || !klass.hasPrimaryConstructor() || !KotlinBuiltIns.getInstance().isData(classDescriptor)) continue;
            ConstructorDescriptor constructor = DescriptorUtils.getConstructorOfDataClass(classDescriptor);
            this.createComponentFunctions(classDescriptor, constructor);
            this.createCopyFunction(classDescriptor, constructor);
        }
    }

    private void createComponentFunctions(@NotNull MutableClassDescriptor classDescriptor, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createComponentFunctions"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createComponentFunctions"));
        }
        int parameterIndex = 0;
        for (ValueParameterDescriptor parameter : constructorDescriptor.getValueParameters()) {
            PropertyDescriptor property2;
            if (parameter.getType().isError() || (property2 = this.trace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter)) == null) continue;
            SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createComponentFunctionDescriptor(++parameterIndex, property2, parameter, classDescriptor, this.trace);
            classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
        }
    }

    private void createCopyFunction(@NotNull MutableClassDescriptor classDescriptor, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createCopyFunction"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createCopyFunction"));
        }
        SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createCopyFunctionDescriptor(constructorDescriptor.getValueParameters(), classDescriptor, this.trace);
        classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
    }

    private void processPrimaryConstructor(@NotNull TopDownAnalysisContext c, @NotNull MutableClassDescriptor classDescriptor, @NotNull JetClass klass) {
        JetParameterList primaryConstructorParameterList;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "processPrimaryConstructor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "processPrimaryConstructor"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "processPrimaryConstructor"));
        }
        if (classDescriptor.getKind() == ClassKind.TRAIT && (primaryConstructorParameterList = klass.getPrimaryConstructorParameterList()) != null) {
            this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(primaryConstructorParameterList));
        }
        boolean isAnnotationClass = DescriptorUtils.isAnnotationClass(classDescriptor);
        JetScope memberScope = classDescriptor.getScopeForClassHeaderResolution();
        ConstructorDescriptorImpl constructorDescriptor = this.descriptorResolver.resolvePrimaryConstructorDescriptor(memberScope, classDescriptor, klass, this.trace);
        if (constructorDescriptor != null) {
            List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
            List<JetParameter> primaryConstructorParameters = klass.getPrimaryConstructorParameters();
            assert (valueParameterDescriptors.size() == primaryConstructorParameters.size());
            ArrayList<ValueParameterDescriptor> notProperties = new ArrayList<ValueParameterDescriptor>();
            for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
                JetParameter parameter = primaryConstructorParameters.get(valueParameterDescriptor.getIndex());
                if (parameter.getValOrVarNode() != null) {
                    PropertyDescriptor propertyDescriptor = this.descriptorResolver.resolvePrimaryConstructorParameterToAProperty(classDescriptor, valueParameterDescriptor, memberScope, parameter, this.trace);
                    classDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                    c.getPrimaryConstructorParameterProperties().put(parameter, propertyDescriptor);
                    continue;
                }
                if (isAnnotationClass) {
                    this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on(parameter));
                }
                notProperties.add(valueParameterDescriptor);
            }
            if (classDescriptor.getKind() != ClassKind.TRAIT) {
                classDescriptor.setPrimaryConstructor(constructorDescriptor);
                classDescriptor.addConstructorParametersToInitializersScope(notProperties);
            }
        }
    }

    private void checkRedeclarationsInPackages(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkRedeclarationsInPackages"));
        }
        for (MutablePackageFragmentDescriptor packageFragment : Sets.newHashSet(c.getPackageFragments().values())) {
            PackageViewDescriptor packageView = packageFragment.getContainingDeclaration().getPackage(packageFragment.getFqName());
            JetScope packageViewScope = packageView.getMemberScope();
            Multimap<Name, DeclarationDescriptor> simpleNameDescriptors = packageFragment.getMemberScope().getDeclaredDescriptorsAccessibleBySimpleName();
            for (Name name : simpleNameDescriptors.keySet()) {
                Collection<DeclarationDescriptor> descriptors = Collections2.filter(simpleNameDescriptors.get(name), new Predicate<DeclarationDescriptor>(){

                    @Override
                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        if (descriptor instanceof PropertyDescriptor) {
                            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                            return propertyDescriptor.getReceiverParameter() == null;
                        }
                        return true;
                    }
                });
                ContainerUtil.addIfNotNull(descriptors, packageViewScope.getPackage(name));
                if (descriptors.size() <= 1) continue;
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    for (PsiElement declaration : this.getDeclarationsByDescriptor(declarationDescriptor)) {
                        assert (declaration != null) : "Null declaration for descriptor: " + declarationDescriptor + " " + (declarationDescriptor != null ? DescriptorRenderer.TEXT.render(declarationDescriptor) : "");
                        this.trace.report(Errors.REDECLARATION.on(declaration, declarationDescriptor.getName().asString()));
                    }
                }
            }
        }
    }

    @NotNull
    private Collection<PsiElement> getDeclarationsByDescriptor(@NotNull DeclarationDescriptor declarationDescriptor) {
        Collection<PsiElement> declarations;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getDeclarationsByDescriptor"));
        }
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            final PackageViewDescriptor aPackage = (PackageViewDescriptor)declarationDescriptor;
            Collection<JetFile> files = this.trace.get(BindingContext.PACKAGE_TO_FILES, aPackage.getFqName());
            if (files == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getDeclarationsByDescriptor"));
                }
                return list;
            }
            declarations = Collections2.transform(files, new Function<JetFile, PsiElement>(){

                @Override
                public PsiElement apply(@Nullable JetFile file) {
                    assert (file != null) : "File is null for aPackage " + aPackage;
                    return file.getPackageDirective().getNameIdentifier();
                }
            });
        } else {
            declarations = Collections.singletonList(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declarationDescriptor));
        }
        List<PsiElement> list = declarations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getDeclarationsByDescriptor"));
        }
        return list;
    }

    private void checkRedeclarationsInInnerClassNames(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkRedeclarationsInInnerClassNames"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getClasses().values()) {
            Collection<DeclarationDescriptor> classObjDescriptors;
            MutableClassDescriptor mutableClassDescriptor = (MutableClassDescriptor)classDescriptor;
            if (classDescriptor.getKind() == ClassKind.CLASS_OBJECT) continue;
            Collection<DeclarationDescriptor> allDescriptors2 = mutableClassDescriptor.getScopeForMemberLookup().getOwnDeclaredDescriptors();
            MutableClassDescriptorLite classObj = mutableClassDescriptor.getClassObjectDescriptor();
            if (classObj != null && !(classObjDescriptors = classObj.getScopeForMemberLookup().getOwnDeclaredDescriptors()).isEmpty()) {
                allDescriptors2 = Lists.newArrayList(allDescriptors2);
                allDescriptors2.addAll(classObjDescriptors);
            }
            HashMultimap<Name, DeclarationDescriptor> descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : allDescriptors2) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            this.reportRedeclarations(descriptorMap);
        }
    }

    private void reportRedeclarations(@NotNull Multimap<Name, DeclarationDescriptor> descriptorMap) {
        if (descriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorMap", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "reportRedeclarations"));
        }
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name name : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(name);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor : descriptors) {
                if (!(descriptor instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor2 : descriptors) {
                    if (descriptor == descriptor2) continue;
                    redeclarations.add(Pair.create(BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), (ClassDescriptor)descriptor), descriptor.getName()));
                    if (!(descriptor2 instanceof PropertyDescriptor)) continue;
                    redeclarations.add(Pair.create(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), descriptor2), descriptor2.getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            this.trace.report(Errors.REDECLARATION.on((PsiElement)pair.getFirst(), ((Name)pair.getSecond()).asString()));
        }
    }
}

