/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Function;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.storage.ExceptionTracker;
import org.jetbrains.jet.storage.StorageManager;

public class CachedBodiesResolveContext
implements BodiesResolveContext {
    private final Collection<JetFile> files;
    private final Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> classes;
    private final Map<JetProperty, PropertyDescriptor> properties;
    private final Map<JetNamedFunction, SimpleFunctionDescriptor> functions;
    private final Function<JetDeclaration, JetScope> declaringScopes;
    private final Map<JetScript, ScriptDescriptor> scripts;
    private final Map<JetScript, WritableScope> scriptScopes;
    private final DataFlowInfo outerDataFlowInfo;
    @NotNull
    private TopDownAnalysisParameters topDownAnalysisParameters;

    public CachedBodiesResolveContext(TopDownAnalysisContext context) {
        this.files = Collections.unmodifiableCollection(context.getFiles());
        this.classes = Collections.unmodifiableMap(context.getClasses());
        this.properties = Collections.unmodifiableMap(context.getProperties());
        this.functions = Collections.unmodifiableMap(context.getFunctions());
        this.declaringScopes = context.getDeclaringScopes();
        this.scripts = Collections.unmodifiableMap(context.getScripts());
        this.scriptScopes = Collections.unmodifiableMap(context.getScriptScopes());
        this.outerDataFlowInfo = context.getOuterDataFlowInfo();
        this.topDownAnalysisParameters = context.getTopDownAnalysisParameters();
    }

    @Override
    @NotNull
    public StorageManager getStorageManager() {
        StorageManager storageManager = this.topDownAnalysisParameters.getStorageManager();
        if (storageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/CachedBodiesResolveContext", "getStorageManager"));
        }
        return storageManager;
    }

    @Override
    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.topDownAnalysisParameters.getExceptionTracker();
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/CachedBodiesResolveContext", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    @Override
    public Collection<JetFile> getFiles() {
        return this.files;
    }

    @Override
    public Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> getClasses() {
        return this.classes;
    }

    @Override
    public Map<JetProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @Override
    public Function<JetDeclaration, JetScope> getDeclaringScopes() {
        return this.declaringScopes;
    }

    @Override
    public Map<JetScript, ScriptDescriptor> getScripts() {
        return this.scripts;
    }

    @Override
    public Map<JetScript, WritableScope> getScriptScopes() {
        return this.scriptScopes;
    }

    @Override
    public DataFlowInfo getOuterDataFlowInfo() {
        return this.outerDataFlowInfo;
    }

    @Override
    @NotNull
    public TopDownAnalysisParameters getTopDownAnalysisParameters() {
        TopDownAnalysisParameters topDownAnalysisParameters = this.topDownAnalysisParameters;
        if (topDownAnalysisParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/CachedBodiesResolveContext", "getTopDownAnalysisParameters"));
        }
        return topDownAnalysisParameters;
    }

    @Override
    public void setTopDownAnalysisParameters(@NotNull TopDownAnalysisParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/resolve/CachedBodiesResolveContext", "setTopDownAnalysisParameters"));
        }
        this.topDownAnalysisParameters = parameters;
    }

    @Override
    public boolean completeAnalysisNeeded(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/CachedBodiesResolveContext", "completeAnalysisNeeded"));
        }
        PsiFile containingFile = element.getContainingFile();
        return containingFile != null && this.topDownAnalysisParameters.getAnalyzeCompletely().apply(containingFile);
    }
}

