/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.util.containers.Queue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetDelegatorToThisCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.ControlFlowAnalyzer;
import org.jetbrains.jet.lang.resolve.DeclarationsChecker;
import org.jetbrains.jet.lang.resolve.DelegatedPropertyResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.FunctionAnalyzerExtension;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.ScriptBodyResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCacheImpl;
import org.jetbrains.jet.lang.resolve.calls.context.SimpleResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.util.ReenteringLazyValueComputationException;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class BodyResolver {
    @NotNull
    private ScriptBodyResolver scriptBodyResolverResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private CallResolver callResolver;
    @NotNull
    private ObservableBindingTrace trace;
    @NotNull
    private ControlFlowAnalyzer controlFlowAnalyzer;
    @NotNull
    private DeclarationsChecker declarationsChecker;
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private FunctionAnalyzerExtension functionAnalyzerExtension;

    public void setScriptBodyResolverResolver(@NotNull ScriptBodyResolver scriptBodyResolverResolver) {
        if (scriptBodyResolverResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptBodyResolverResolver", "org/jetbrains/jet/lang/resolve/BodyResolver", "setScriptBodyResolverResolver"));
        }
        this.scriptBodyResolverResolver = scriptBodyResolverResolver;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/BodyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setCallResolver(@NotNull CallResolver callResolver) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/jet/lang/resolve/BodyResolver", "setCallResolver"));
        }
        this.callResolver = callResolver;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/BodyResolver", "setTrace"));
        }
        this.trace = new ObservableBindingTrace(trace);
    }

    public void setControlFlowAnalyzer(@NotNull ControlFlowAnalyzer controlFlowAnalyzer) {
        if (controlFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlFlowAnalyzer", "org/jetbrains/jet/lang/resolve/BodyResolver", "setControlFlowAnalyzer"));
        }
        this.controlFlowAnalyzer = controlFlowAnalyzer;
    }

    public void setDeclarationsChecker(@NotNull DeclarationsChecker declarationsChecker) {
        if (declarationsChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsChecker", "org/jetbrains/jet/lang/resolve/BodyResolver", "setDeclarationsChecker"));
        }
        this.declarationsChecker = declarationsChecker;
    }

    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/lang/resolve/BodyResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    public void setDelegatedPropertyResolver(@NotNull DelegatedPropertyResolver delegatedPropertyResolver) {
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/jet/lang/resolve/BodyResolver", "setDelegatedPropertyResolver"));
        }
        this.delegatedPropertyResolver = delegatedPropertyResolver;
    }

    public void setFunctionAnalyzerExtension(@NotNull FunctionAnalyzerExtension functionAnalyzerExtension) {
        if (functionAnalyzerExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionAnalyzerExtension", "org/jetbrains/jet/lang/resolve/BodyResolver", "setFunctionAnalyzerExtension"));
        }
        this.functionAnalyzerExtension = functionAnalyzerExtension;
    }

    private void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveBehaviorDeclarationBodies"));
        }
        this.resolveDelegationSpecifierLists(c);
        this.resolvePropertyDeclarationBodies(c);
        this.resolveClassAnnotations(c);
        this.resolveAnonymousInitializers(c);
        this.resolvePrimaryConstructorParameters(c);
        this.resolveFunctionBodies(c);
        this.scriptBodyResolverResolver.resolveScriptBodies(c);
        if (!c.getTopDownAnalysisParameters().isDeclaredLocally()) {
            this.computeDeferredTypes();
        }
    }

    public void resolveBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveBodies"));
        }
        this.resolveBehaviorDeclarationBodies(c);
        this.controlFlowAnalyzer.process(c);
        this.declarationsChecker.process(c);
        this.functionAnalyzerExtension.process(c);
    }

    private void resolveDelegationSpecifierLists(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveDelegationSpecifierLists"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor = entry.getValue();
            this.resolveDelegationSpecifierList(c, classOrObject, descriptor, descriptor.getUnsubstitutedPrimaryConstructor(), descriptor.getScopeForClassHeaderResolution(), descriptor.getScopeForMemberDeclarationResolution());
        }
    }

    public void resolveDelegationSpecifierList(final @NotNull BodiesResolveContext c, @NotNull JetClassOrObject jetClass, final @NotNull ClassDescriptor descriptor, final @Nullable ConstructorDescriptor primaryConstructor, @NotNull JetScope scopeForSupertypeResolution, final @NotNull JetScope scopeForMemberResolution) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (scopeForSupertypeResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForSupertypeResolution", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (scopeForMemberResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForMemberResolution", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (!c.completeAnalysisNeeded(jetClass)) {
            return;
        }
        final JetScope scopeForConstructor = primaryConstructor == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(scopeForSupertypeResolution, primaryConstructor, this.trace);
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap<JetTypeReference, JetType> supertypes = Maps.newLinkedHashMap();
        JetVisitorVoid visitor = new JetVisitorVoid(){

            private void recordSupertype(JetTypeReference typeReference, JetType supertype) {
                if (supertype == null) {
                    return;
                }
                supertypes.put(typeReference, supertype);
            }

            @Override
            public void visitDelegationByExpressionSpecifier(@NotNull JetDelegatorByExpressionSpecifier specifier) {
                JetScope scope;
                JetType type;
                JetExpression delegateExpression;
                ClassDescriptor classDescriptor;
                ClassifierDescriptor declarationDescriptor;
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/resolve/BodyResolver$1", "visitDelegationByExpressionSpecifier"));
                }
                if (descriptor.getKind() == ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_TRAIT.on(specifier));
                }
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype);
                if (supertype != null && (declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_TRAIT.on(specifier.getTypeReference()));
                }
                if ((delegateExpression = specifier.getDelegateExpression()) != null && (type = typeInferrer.getType(scope = scopeForConstructor == null ? scopeForMemberResolution : scopeForConstructor, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, c.getOuterDataFlowInfo(), BodyResolver.this.trace)) != null && supertype != null) {
                    SimpleResolutionContext simpleResolutionContext = new SimpleResolutionContext(BodyResolver.this.trace, scope, supertype, c.getOuterDataFlowInfo(), ContextDependency.INDEPENDENT, ResolutionResultsCacheImpl.create(), LabelResolver.create(), BodyResolver.this.expressionTypingServices.createExtension(scope, false), false);
                    DataFlowUtils.checkType(type, delegateExpression, (ResolutionContext)simpleResolutionContext);
                }
            }

            @Override
            public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
                JetTypeReference typeReference;
                JetElementImpl elementToMark;
                if (call == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/BodyResolver$1", "visitDelegationToSuperCallSpecifier"));
                }
                JetValueArgumentList valueArgumentList = call.getValueArgumentList();
                JetElementImpl jetElementImpl = elementToMark = valueArgumentList == null ? call : valueArgumentList;
                if (descriptor.getKind() == ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_TRAIT.on(elementToMark));
                }
                if ((typeReference = call.getTypeReference()) == null) {
                    return;
                }
                if (primaryConstructor == null) {
                    assert (descriptor.getKind() == ClassKind.TRAIT);
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, c.getOuterDataFlowInfo(), false);
                if (results.isSuccess()) {
                    JetType supertype = results.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype);
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                    if (classDescriptor != null && classDescriptor.getKind() == ClassKind.TRAIT) {
                        BodyResolver.this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(elementToMark));
                    }
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitDelegationToSuperClassSpecifier(@NotNull JetDelegatorToSuperClass specifier) {
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/resolve/BodyResolver$1", "visitDelegationToSuperClassSpecifier"));
                }
                JetTypeReference typeReference = specifier.getTypeReference();
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype);
                if (supertype == null) {
                    return;
                }
                ClassDescriptor superClass = TypeUtils.getClassDescriptor(supertype);
                if (superClass == null) {
                    return;
                }
                if (superClass.getKind().isSingleton()) {
                    return;
                }
                if (descriptor.getKind() != ClassKind.TRAIT && !superClass.getConstructors().isEmpty() && !ErrorUtils.isError(superClass)) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                }
            }

            @Override
            public void visitDelegationToThisCall(@NotNull JetDelegatorToThisCall thisCall) {
                if (thisCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisCall", "org/jetbrains/jet/lang/resolve/BodyResolver$1", "visitDelegationToThisCall"));
                }
                throw new IllegalStateException("This-calls should be prohibited by the parser");
            }

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/BodyResolver$1", "visitJetElement"));
                }
                throw new UnsupportedOperationException(element.getText() + " : " + element);
            }
        };
        for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
            delegationSpecifier.accept(visitor);
        }
        if (DescriptorUtils.isAnnotationClass(descriptor) && jetClass.getDelegationSpecifierList() != null) {
            this.trace.report(Errors.SUPERTYPES_FOR_ANNOTATION_CLASS.on(jetClass.getDelegationSpecifierList()));
        }
        Set<TypeConstructor> parentEnum = jetClass instanceof JetEnumEntry ? Collections.singleton(((ClassDescriptor)descriptor.getContainingDeclaration()).getTypeConstructor()) : Collections.emptySet();
        this.checkSupertypeList(descriptor, supertypes, parentEnum);
    }

    private void checkSupertypeList(@NotNull ClassDescriptor supertypeOwner, @NotNull Map<JetTypeReference, JetType> supertypes, @NotNull Set<TypeConstructor> allowedFinalSupertypes) {
        if (supertypeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypeOwner", "org/jetbrains/jet/lang/resolve/BodyResolver", "checkSupertypeList"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/resolve/BodyResolver", "checkSupertypeList"));
        }
        if (allowedFinalSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedFinalSupertypes", "org/jetbrains/jet/lang/resolve/BodyResolver", "checkSupertypeList"));
        }
        HashSet<TypeConstructor> typeConstructors = Sets.newHashSet();
        boolean classAppeared = false;
        for (Map.Entry<JetTypeReference, JetType> entry : supertypes.entrySet()) {
            TypeConstructor constructor;
            JetTypeReference typeReference = entry.getKey();
            JetType supertype = entry.getValue();
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
            if (classDescriptor != null) {
                if (classDescriptor.getKind() != ClassKind.TRAIT) {
                    if (supertypeOwner.getKind() == ClassKind.ENUM_CLASS) {
                        this.trace.report(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM.on(typeReference));
                    }
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_TRAIT.on(typeReference));
            }
            if (!typeConstructors.add(constructor = supertype.getConstructor())) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (DescriptorUtils.isSingleton(classDescriptor)) {
                this.trace.report(Errors.SINGLETON_IN_SUPERTYPE.on(typeReference));
                continue;
            }
            if (!constructor.isFinal() || allowedFinalSupertypes.contains(constructor)) continue;
            this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
        }
    }

    private void resolveClassAnnotations(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveClassAnnotations"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            this.resolveAnnotationArguments(entry.getValue().getScopeForClassHeaderResolution(), entry.getKey());
        }
    }

    private void resolveAnonymousInitializers(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveAnonymousInitializers"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor = entry.getValue();
            this.resolveAnonymousInitializers(c, classOrObject, descriptor.getUnsubstitutedPrimaryConstructor(), descriptor.getScopeForInitializerResolution());
        }
    }

    public void resolveAnonymousInitializers(@NotNull BodiesResolveContext c, @NotNull JetClassOrObject jetClassOrObject, @Nullable ConstructorDescriptor primaryConstructor, @NotNull JetScope scopeForInitializers) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveAnonymousInitializers"));
        }
        if (jetClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClassOrObject", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveAnonymousInitializers"));
        }
        if (scopeForInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForInitializers", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveAnonymousInitializers"));
        }
        if (!c.completeAnalysisNeeded(jetClassOrObject)) {
            return;
        }
        List<JetClassInitializer> anonymousInitializers = jetClassOrObject.getAnonymousInitializers();
        if (primaryConstructor != null) {
            for (JetClassInitializer anonymousInitializer : anonymousInitializers) {
                this.expressionTypingServices.getType(scopeForInitializers, anonymousInitializer.getBody(), TypeUtils.NO_EXPECTED_TYPE, c.getOuterDataFlowInfo(), this.trace);
                this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
            }
        } else {
            for (JetClassInitializer anonymousInitializer : anonymousInitializers) {
                this.trace.report(Errors.ANONYMOUS_INITIALIZER_IN_TRAIT.on(anonymousInitializer));
                this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
            }
        }
    }

    private void processModifiersOnInitializer(@NotNull JetModifierListOwner owner, @NotNull JetScope scope) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/BodyResolver", "processModifiersOnInitializer"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/BodyResolver", "processModifiersOnInitializer"));
        }
        JetModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            return;
        }
        this.annotationResolver.resolveAnnotationsWithArguments(scope, modifierList, (BindingTrace)this.trace);
        for (ASTNode node : modifierList.getModifierNodes()) {
            this.trace.report(Errors.ILLEGAL_MODIFIER.on(node.getPsi(), (JetKeywordToken)node.getElementType()));
        }
    }

    private void resolvePrimaryConstructorParameters(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePrimaryConstructorParameters"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            if (!(entry.getKey() instanceof JetClass)) continue;
            JetClass klass = (JetClass)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            ConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            this.annotationResolver.resolveAnnotationsArguments(classDescriptor.getScopeForClassHeaderResolution(), klass.getPrimaryConstructorModifierList(), this.trace);
            if (unsubstitutedPrimaryConstructor == null) continue;
            WritableScope parameterScope = BodyResolver.getPrimaryConstructorParametersScope(classDescriptor.getScopeForClassHeaderResolution(), unsubstitutedPrimaryConstructor);
            this.expressionTypingServices.resolveValueParameters(klass.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), parameterScope, c.getOuterDataFlowInfo(), this.trace, c.completeAnalysisNeeded(klass));
        }
    }

    private static WritableScope getPrimaryConstructorParametersScope(JetScope originalScope, ConstructorDescriptor unsubstitutedPrimaryConstructor) {
        WritableScopeImpl parameterScope = new WritableScopeImpl(originalScope, unsubstitutedPrimaryConstructor, RedeclarationHandler.DO_NOTHING, "Scope with value parameters of a constructor");
        for (ValueParameterDescriptor valueParameterDescriptor : unsubstitutedPrimaryConstructor.getValueParameters()) {
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
        }
        parameterScope.changeLockLevel(WritableScope.LockLevel.READING);
        return parameterScope;
    }

    private void resolvePropertyDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDeclarationBodies"));
        }
        HashSet<JetProperty> processed = Sets.newHashSet();
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            if (!(entry.getKey() instanceof JetClass)) continue;
            JetClass jetClass = (JetClass)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            for (JetProperty property2 : jetClass.getProperties()) {
                JetExpression delegateExpression;
                ConstructorDescriptor primaryConstructor;
                PropertyDescriptor propertyDescriptor = c.getProperties().get(property2);
                assert (propertyDescriptor != null);
                BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
                JetExpression initializer = property2.getInitializer();
                JetScope propertyScope = this.getScopeForProperty(c, property2);
                if (initializer != null && (primaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
                    this.resolvePropertyInitializer(c, property2, propertyDescriptor, initializer, propertyScope);
                }
                if ((delegateExpression = property2.getDelegateExpression()) != null) {
                    assert (initializer == null) : "Initializer should be null for delegated property : " + property2.getText();
                    this.resolvePropertyDelegate(c, property2, propertyDescriptor, delegateExpression, classDescriptor.getScopeForMemberDeclarationResolution(), propertyScope);
                }
                this.resolveAnnotationArguments(propertyScope, property2);
                this.resolvePropertyAccessors(c, property2, propertyDescriptor);
                processed.add(property2);
            }
        }
        for (Map.Entry<JetNamedDeclaration, MemberDescriptor> entry : c.getProperties().entrySet()) {
            JetExpression delegateExpression;
            JetProperty property3 = (JetProperty)entry.getKey();
            if (processed.contains(property3)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
            JetExpression initializer = property3.getInitializer();
            JetScope propertyScope = this.getScopeForProperty(c, property3);
            if (initializer != null) {
                this.resolvePropertyInitializer(c, property3, propertyDescriptor, initializer, propertyScope);
            }
            if ((delegateExpression = property3.getDelegateExpression()) != null) {
                assert (initializer == null) : "Initializer should be null for delegated property : " + property3.getText();
                this.resolvePropertyDelegate(c, property3, propertyDescriptor, delegateExpression, propertyScope, propertyScope);
            }
            this.resolveAnnotationArguments(propertyScope, property3);
            this.resolvePropertyAccessors(c, property3, propertyDescriptor);
        }
    }

    private JetScope makeScopeForPropertyAccessor(@NotNull BodiesResolveContext c, @NotNull JetPropertyAccessor accessor, @NotNull PropertyDescriptor descriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/lang/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        JetScope accessorDeclaringScope = c.getDeclaringScopes().apply(accessor);
        assert (accessorDeclaringScope != null) : "Scope for accessor " + accessor.getText() + " should exists";
        return JetScopeUtils.makeScopeForPropertyAccessor(descriptor, accessorDeclaringScope, this.trace);
    }

    public void resolvePropertyAccessors(@NotNull BodiesResolveContext c, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        JetPropertyAccessor getter = property2.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        if (getter != null && getterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(c, getter, propertyDescriptor);
            this.resolveAnnotationArguments(accessorScope, getter);
            this.resolveFunctionBody(c, fieldAccessTrackingTrace, getter, getterDescriptor, accessorScope);
        }
        JetPropertyAccessor setter = property2.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setter != null && setterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(c, setter, propertyDescriptor);
            this.resolveAnnotationArguments(accessorScope, setter);
            this.resolveFunctionBody(c, fieldAccessTrackingTrace, setter, setterDescriptor, accessorScope);
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(final PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, new ObservableBindingTrace.RecordHandler<JetReferenceExpression, DeclarationDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<JetReferenceExpression, DeclarationDescriptor> slice, JetReferenceExpression expression, DeclarationDescriptor descriptor) {
                JetSimpleNameExpression simpleNameExpression;
                if (expression instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)expression).getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER && descriptor == propertyDescriptor) {
                    BodyResolver.this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                }
            }
        });
    }

    public void resolvePropertyDelegate(@NotNull BodiesResolveContext c, @NotNull JetProperty jetProperty, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetScope parentScopeForAccessor, @NotNull JetScope propertyScope) {
        JetPropertyAccessor setter;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (jetProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetProperty", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (parentScopeForAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScopeForAccessor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (propertyScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyScope", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        JetPropertyAccessor getter = jetProperty.getGetter();
        if (getter != null) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(getter));
        }
        if ((setter = jetProperty.getSetter()) != null) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(setter));
        }
        JetScope propertyDeclarationInnerScope = JetScopeUtils.getPropertyDeclarationInnerScopeForInitializer(propertyScope, propertyDescriptor.getTypeParameters(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, this.trace);
        JetScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, parentScopeForAccessor, this.trace);
        JetType delegateType = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, jetProperty, propertyDescriptor, propertyDeclarationInnerScope, accessorScope, this.trace, c.getOuterDataFlowInfo());
        this.delegatedPropertyResolver.resolveDelegatedPropertyGetMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, accessorScope);
        if (jetProperty.isVar()) {
            this.delegatedPropertyResolver.resolveDelegatedPropertySetMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, accessorScope);
        }
    }

    public void resolvePropertyInitializer(@NotNull BodiesResolveContext c, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression initializer, @NotNull JetScope scope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        JetScope propertyDeclarationInnerScope = JetScopeUtils.getPropertyDeclarationInnerScopeForInitializer(scope, propertyDescriptor.getTypeParameters(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, this.trace);
        JetType expectedTypeForInitializer = property2.getTypeRef() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer, expectedTypeForInitializer, c.getOuterDataFlowInfo(), this.trace);
        EvaluatePackage.recordCompileTimeValueForInitializerIfNeeded(propertyDescriptor, initializer, expectedTypeForInitializer, this.trace);
    }

    @NotNull
    private JetScope getScopeForProperty(@NotNull BodiesResolveContext c, @NotNull JetProperty property2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "getScopeForProperty"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/BodyResolver", "getScopeForProperty"));
        }
        JetScope scope = c.getDeclaringScopes().apply(property2);
        assert (scope != null) : "Scope for property " + property2.getText() + " should exists";
        JetScope jetScope = scope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/BodyResolver", "getScopeForProperty"));
        }
        return jetScope;
    }

    private void resolveFunctionBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveFunctionBodies"));
        }
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : c.getFunctions().entrySet()) {
            JetNamedFunction declaration = entry.getKey();
            SimpleFunctionDescriptor descriptor = entry.getValue();
            BodyResolver.computeDeferredType(descriptor.getReturnType());
            JetScope declaringScope = c.getDeclaringScopes().apply(declaration);
            assert (declaringScope != null);
            this.resolveAnnotationArguments(declaringScope, declaration);
            this.resolveFunctionBody(c, this.trace, declaration, descriptor, declaringScope);
            assert (descriptor.getReturnType() != null);
        }
    }

    public void resolveFunctionBody(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull JetScope declaringScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveFunctionBody"));
        }
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(declaringScope, functionDescriptor, trace);
        List<JetParameter> valueParameters = function.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        boolean needCompleteAnalysis = c.completeAnalysisNeeded(function);
        this.expressionTypingServices.resolveValueParameters(valueParameters, valueParameterDescriptors, functionInnerScope, c.getOuterDataFlowInfo(), trace, needCompleteAnalysis);
        if (!needCompleteAnalysis) {
            return;
        }
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression != null) {
            this.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, c.getOuterDataFlowInfo(), null, trace);
        }
        assert (functionDescriptor.getReturnType() != null);
    }

    public void resolveConstructorParameterDefaultValuesAndAnnotations(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace, @NotNull JetClass klass, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull JetScope declaringScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (!c.completeAnalysisNeeded(klass)) {
            return;
        }
        List<JetParameter> valueParameters = klass.getPrimaryConstructorParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
        WritableScope scope = BodyResolver.getPrimaryConstructorParametersScope(declaringScope, constructorDescriptor);
        this.expressionTypingServices.resolveValueParameters(valueParameters, valueParameterDescriptors, scope, c.getOuterDataFlowInfo(), trace, true);
    }

    private void resolveAnnotationArguments(@NotNull JetScope scope, @NotNull JetModifierListOwner owner) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveAnnotationArguments"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/BodyResolver", "resolveAnnotationArguments"));
        }
        this.annotationResolver.resolveAnnotationsArguments(scope, owner.getModifierList(), this.trace);
    }

    private static void computeDeferredType(JetType type) {
        DeferredType deferredType;
        if (type instanceof DeferredType && !(deferredType = (DeferredType)type).isComputed()) {
            deferredType.getActualType();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes != null) {
            final Queue<DeferredType> queue = new Queue<DeferredType>(deferredTypes.size() + 1);
            this.trace.addHandler(BindingContext.DEFERRED_TYPE, new ObservableBindingTrace.RecordHandler<Box<DeferredType>, Boolean>(){

                @Override
                public void handleRecord(WritableSlice<Box<DeferredType>, Boolean> deferredTypeKeyDeferredTypeWritableSlice, Box<DeferredType> key, Boolean value) {
                    queue.addLast(key.getData());
                }
            });
            for (Box<DeferredType> deferredType : deferredTypes) {
                queue.addLast(deferredType.getData());
            }
            while (!queue.isEmpty()) {
                DeferredType deferredType = (DeferredType)queue.pullFirst();
                if (deferredType.isComputed()) continue;
                try {
                    deferredType.getActualType();
                }
                catch (ReenteringLazyValueComputationException reenteringLazyValueComputationException) {}
            }
        }
    }
}

