/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.stubs.PsiJetObjectStub;
import org.jetbrains.jet.lang.psi.stubs.impl.Utils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetObjectStubImpl
extends StubBase<JetObjectDeclaration>
implements PsiJetObjectStub {
    private final StringRef name;
    private final FqName fqName;
    private final StringRef[] superNames;
    private final boolean isTopLevel;
    private final boolean isClassObject;
    private final boolean isLocal;

    public PsiJetObjectStubImpl(@NotNull IStubElementType elementType, StubElement parent, @Nullable String name, @Nullable FqName fqName, @NotNull List<String> superNames, boolean isTopLevel, boolean isClassObject, boolean isLocal) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        if (superNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superNames", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        this(elementType, parent, StringRef.fromString(name), fqName, Utils.instance$.wrapStrings(superNames), isTopLevel, isClassObject, isLocal);
    }

    public PsiJetObjectStubImpl(@NotNull IStubElementType elementType, StubElement parent, @Nullable StringRef name, @Nullable FqName fqName, @NotNull StringRef[] superNames, boolean isTopLevel, boolean isClassObject, boolean isLocal) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        if (superNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superNames", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "<init>"));
        }
        super(parent, elementType);
        this.name = name;
        this.fqName = fqName;
        this.superNames = superNames;
        this.isTopLevel = isTopLevel;
        this.isClassObject = isClassObject;
        this.isLocal = isLocal;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }

    @Override
    @NotNull
    public List<String> getSuperNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StringRef ref : this.superNames) {
            result.add(ref.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetObjectStubImpl", "getSuperNames"));
        }
        return arrayList;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isClassObject() {
        return this.isClassObject;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetObjectStubImpl[");
        if (this.isClassObject) {
            builder.append("class-object ");
        }
        if (this.isTopLevel) {
            builder.append("top ");
        }
        if (this.isLocal()) {
            builder.append("local ");
        }
        builder.append("name=").append(this.getName());
        builder.append(" fqName=").append(this.fqName != null ? this.fqName.toString() : "null");
        builder.append(" superNames=").append("[").append(StringUtil.join(ArrayUtil.toStringArray(this.getSuperNames()))).append("]");
        builder.append("]");
        return builder.toString();
    }
}

