/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeConstraint
extends JetElementImpl {
    public JetTypeConstraint(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetTypeConstraint", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetTypeConstraint", "accept"));
        }
        return visitor.visitTypeConstraint(this, data2);
    }

    public boolean isClassObjectConstraint() {
        return this.findChildByType(JetTokens.CLASS_KEYWORD) != null && this.findChildByType(JetTokens.OBJECT_KEYWORD) != null;
    }

    @IfNotParsed
    @Nullable
    public JetSimpleNameExpression getSubjectTypeParameterName() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
    }

    @IfNotParsed
    @Nullable
    public JetTypeReference getBoundTypeReference() {
        boolean passedColon = false;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == JetTokens.COLON) {
                passedColon = true;
            }
            if (!passedColon || tt != JetNodeTypes.TYPE_REFERENCE) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }
}

