/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.utils.Printer;

public class SubpackagesScope
extends JetScopeImpl {
    private final PackageViewDescriptor packageView;

    public SubpackagesScope(PackageViewDescriptor packageView) {
        this.packageView = packageView;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        PackageViewDescriptor packageViewDescriptor = this.packageView;
        if (packageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/SubpackagesScope", "getContainingDeclaration"));
        }
        return packageViewDescriptor;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/SubpackagesScope", "getPackage"));
        }
        return name.isSpecial() ? null : this.packageView.getModule().getPackage(this.packageView.getFqName().child(name));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        ArrayList<DeclarationDescriptor> result = Lists.newArrayList();
        for (FqName subFqName : this.packageView.getModule().getPackageFragmentProvider().getSubPackagesOf(this.packageView.getFqName())) {
            ContainerUtil.addIfNotNull(result, this.getPackage(subFqName.shortName()));
        }
        ArrayList<DeclarationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/SubpackagesScope", "getAllDescriptors"));
        }
        return arrayList;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/descriptors/impl/SubpackagesScope", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.println("thisDescriptor = ", this.packageView);
        p.popIndent();
        p.println("}");
    }
}

