/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.annotations;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class AnnotationDescriptorImpl
implements AnnotationDescriptor {
    private JetType annotationType;
    private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> valueArguments = Maps.newHashMap();

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = this.annotationType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "getType"));
        }
        return jetType;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> getValueArgument(@NotNull ValueParameterDescriptor valueParameterDescriptor) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "getValueArgument"));
        }
        return this.valueArguments.get(valueParameterDescriptor);
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, CompileTimeConstant<?>> getAllValueArguments() {
        Map<ValueParameterDescriptor, CompileTimeConstant<?>> map = Collections.unmodifiableMap(this.valueArguments);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "getAllValueArguments"));
        }
        return map;
    }

    public void setAnnotationType(@NotNull JetType annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationType", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "setAnnotationType"));
        }
        this.annotationType = annotationType;
    }

    public void setValueArgument(@NotNull ValueParameterDescriptor name, @NotNull CompileTimeConstant<?> value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "setValueArgument"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationDescriptorImpl", "setValueArgument"));
        }
        this.valueArguments.put(name, value);
    }

    public String toString() {
        return DescriptorRenderer.TEXT.renderAnnotation(this);
    }
}

