/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.utils.UtilsPackage;

public final class ClassData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Class classProto;

    @NotNull
    public static ClassData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        ClassData classData;
        block4: {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/jet/descriptors/serialization/ClassData", "read"));
            }
            if (registry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "org/jetbrains/jet/descriptors/serialization/ClassData", "read"));
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                NameResolver nameResolver = NameSerializationUtil.deserializeNameResolver(in);
                ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(in, registry);
                classData = new ClassData(nameResolver, classProto);
                if (classData != null) break block4;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassData", "read"));
        }
        return classData;
    }

    public ClassData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/ClassData", "<init>"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/jet/descriptors/serialization/ClassData", "<init>"));
        }
        this.nameResolver = nameResolver;
        this.classProto = classProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        NameResolver nameResolver = this.nameResolver;
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassData", "getNameResolver"));
        }
        return nameResolver;
    }

    @NotNull
    public ProtoBuf.Class getClassProto() {
        ProtoBuf.Class clazz = this.classProto;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassData", "getClassProto"));
        }
        return clazz;
    }

    @NotNull
    public byte[] toBytes() {
        byte[] byArray;
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            NameSerializationUtil.serializeNameResolver(result, this.nameResolver);
            this.classProto.writeTo(result);
            byArray = result.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassData", "toBytes"));
        }
        return byArray;
    }
}

