/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.psi.JetExpression;

public class BinaryOp
extends IntrinsicMethod {
    private final int opcode;

    public BinaryOp(int opcode) {
        this.opcode = opcode;
    }

    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType, PsiElement element, List<JetExpression> arguments, StackValue receiver) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/intrinsics/BinaryOp", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/intrinsics/BinaryOp", "generateImpl"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/intrinsics/BinaryOp", "generateImpl"));
        }
        assert (AsmUtil.isPrimitive(returnType)) : "Return type of BinaryOp intrinsic should be of primitive type : " + returnType;
        Type operandType = AsmUtil.numberFunctionOperandType(returnType);
        if (arguments.size() == 1) {
            if (receiver != null) {
                receiver.put(operandType, v);
            }
            codegen.gen(arguments.get(0), this.shift() ? Type.INT_TYPE : operandType);
        } else {
            codegen.gen(arguments.get(0), operandType);
            codegen.gen(arguments.get(1), this.shift() ? Type.INT_TYPE : operandType);
        }
        v.visitInsn(returnType.getOpcode(this.opcode));
        Type type = returnType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/BinaryOp", "generateImpl"));
        }
        return type;
    }

    private boolean shift() {
        return this.opcode == 120 || this.opcode == 122 || this.opcode == 124;
    }
}

