/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.tree.AbstractInsnNode;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.LambdaFieldRemapper;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.LambdaTransformer;
import org.jetbrains.jet.codegen.inline.Parameters;

public class RegeneratedLambdaFieldRemapper
extends LambdaFieldRemapper {
    private final String oldOwnerType;
    private final String newOwnerType;
    private final Parameters parameters;
    private final Map<String, LambdaInfo> recapturedLambdas;

    public RegeneratedLambdaFieldRemapper(String oldOwnerType, String newOwnerType, Parameters parameters, Map<String, LambdaInfo> recapturedLambdas) {
        this.oldOwnerType = oldOwnerType;
        this.newOwnerType = newOwnerType;
        this.parameters = parameters;
        this.recapturedLambdas = recapturedLambdas;
    }

    @Override
    public AbstractInsnNode doTransform(MethodNode node, FieldInsnNode fieldInsnNode, CapturedParamInfo capturedField) {
        boolean isRecaptured = this.isRecapturedLambdaType(fieldInsnNode.owner);
        if (!isRecaptured && capturedField.getLambda() != null) {
            return super.doTransform(node, fieldInsnNode, capturedField);
        }
        AbstractInsnNode loadThis = RegeneratedLambdaFieldRemapper.getPreviousThis(fieldInsnNode);
        int opcode = 178;
        String descriptor = Type.getObjectType(this.newOwnerType).getDescriptor();
        FieldInsnNode thisStub = new FieldInsnNode(opcode, this.newOwnerType, "$$$this", descriptor);
        node.instructions.insertBefore(loadThis, thisStub);
        node.instructions.remove(loadThis);
        fieldInsnNode.owner = this.newOwnerType;
        fieldInsnNode.name = isRecaptured || capturedField.getRecapturedFrom() != null ? LambdaTransformer.getNewFieldName(capturedField.getFieldName()) : capturedField.getFieldName();
        return fieldInsnNode;
    }

    @Override
    public List<CapturedParamInfo> markRecaptured(List<CapturedParamInfo> originalCaptured, LambdaInfo lambda) {
        List<CapturedParamInfo> captured = this.parameters.getCaptured();
        for (CapturedParamInfo originalField : originalCaptured) {
            for (CapturedParamInfo capturedParamInfo : captured) {
                if (capturedParamInfo.getRecapturedFrom() != lambda || !capturedParamInfo.getFieldName().equals(LambdaTransformer.getNewFieldName(originalField.getFieldName()))) continue;
                originalField.setRecapturedFrom(lambda);
            }
        }
        return originalCaptured;
    }

    @Override
    public boolean canProcess(String owner, String currentLambdaType) {
        return super.canProcess(owner, currentLambdaType) || this.isRecapturedLambdaType(owner);
    }

    private boolean isRecapturedLambdaType(String owner) {
        return this.recapturedLambdas.containsKey(owner);
    }

    @Override
    @Nullable
    public CapturedParamInfo findField(FieldInsnNode fieldInsnNode, Collection<CapturedParamInfo> captured) {
        if (this.isRecapturedLambdaType(fieldInsnNode.owner)) {
            LambdaInfo info = this.recapturedLambdas.get(fieldInsnNode.owner);
            return super.findField(fieldInsnNode, info.getCapturedVars());
        }
        return super.findField(fieldInsnNode, captured);
    }
}

