/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.ParameterInfo;
import org.jetbrains.jet.codegen.inline.Parameters;

public class ParametersBuilder {
    private final List<ParameterInfo> params = new ArrayList<ParameterInfo>();
    private final List<CapturedParamInfo> capturedParams = new ArrayList<CapturedParamInfo>();
    private int nextIndex = 0;
    private int nextCaptured = 0;

    public static ParametersBuilder newBuilder() {
        return new ParametersBuilder();
    }

    public ParameterInfo addThis(Type type, boolean skipped) {
        ParameterInfo info = new ParameterInfo(type, skipped, this.nextIndex, -1);
        this.addParameter(info);
        return info;
    }

    public ParametersBuilder addNextParameter(Type type, boolean skipped, @Nullable ParameterInfo original) {
        this.addParameter(new ParameterInfo(type, skipped, this.nextIndex, original != null ? original.getIndex() : -1));
        return this;
    }

    public CapturedParamInfo addCapturedParam(String fieldName, Type type, boolean skipped, @Nullable ParameterInfo original) {
        return this.addCapturedParameter(new CapturedParamInfo(fieldName, type, skipped, this.nextCaptured, original != null ? original.getIndex() : -1));
    }

    private void addParameter(ParameterInfo info) {
        this.params.add(info);
        this.nextIndex += info.getType().getSize();
    }

    private CapturedParamInfo addCapturedParameter(CapturedParamInfo info) {
        this.capturedParams.add(info);
        this.nextCaptured += info.getType().getSize();
        return info;
    }

    public List<ParameterInfo> build() {
        return Collections.unmodifiableList(this.params);
    }

    public List<CapturedParamInfo> buildCaptured() {
        return Collections.unmodifiableList(this.capturedParams);
    }

    public List<ParameterInfo> buildWithStubs() {
        return Parameters.addStubs(this.build());
    }

    public List<CapturedParamInfo> buildCapturedWithStubs() {
        return Parameters.shiftAndAddStubs(this.buildCaptured(), this.nextIndex);
    }

    public Parameters buildParameters() {
        return new Parameters(this.buildWithStubs(), this.buildCapturedWithStubs());
    }
}

