/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.tree.AbstractInsnNode;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.asm4.tree.VarInsnNode;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.MethodInliner;

public class LambdaFieldRemapper {
    public AbstractInsnNode doTransform(MethodNode node, FieldInsnNode fieldInsnNode, CapturedParamInfo capturedField) {
        AbstractInsnNode loadThis = LambdaFieldRemapper.getPreviousThis(fieldInsnNode);
        int opcode = fieldInsnNode.getOpcode() == 180 ? capturedField.getType().getOpcode(21) : capturedField.getType().getOpcode(54);
        VarInsnNode newInstruction = new VarInsnNode(opcode, capturedField.getIndex());
        node.instructions.remove(loadThis);
        node.instructions.insertBefore(fieldInsnNode, newInstruction);
        node.instructions.remove(fieldInsnNode);
        return newInstruction;
    }

    protected static AbstractInsnNode getPreviousThis(FieldInsnNode fieldInsnNode) {
        AbstractInsnNode loadThis = MethodInliner.getPreviousNoLabelNoLine(fieldInsnNode);
        assert (loadThis.getType() == 2 || loadThis.getType() == 4) : "Field access instruction should go after load this but goes after " + loadThis;
        assert (loadThis.getOpcode() == 25 || loadThis.getOpcode() == 178) : "This should be loaded by ALOAD or GETSTATIC but " + loadThis.getOpcode();
        return loadThis;
    }

    public List<CapturedParamInfo> markRecaptured(List<CapturedParamInfo> originalCaptured, LambdaInfo lambda) {
        return originalCaptured;
    }

    public boolean canProcess(String owner, String currentLambdaType) {
        return owner.equals(currentLambdaType);
    }

    @Nullable
    public CapturedParamInfo findField(FieldInsnNode fieldInsnNode, Collection<CapturedParamInfo> captured) {
        for (CapturedParamInfo valueDescriptor : captured) {
            if (!valueDescriptor.getFieldName().equals(fieldInsnNode.name)) continue;
            return valueDescriptor;
        }
        return null;
    }
}

