/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.ParentCodegenAwareImpl;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.LocalLookup;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ClosureCodegen
extends ParentCodegenAwareImpl {
    private final PsiElement fun;
    private final FunctionDescriptor funDescriptor;
    private final ClassDescriptor samInterface;
    private final Type superClass;
    private final CodegenContext context;
    private final FunctionGenerationStrategy strategy;
    private final CalculatedClosure closure;
    private final Type asmType;
    private final int visibilityFlag;
    private Method constructor;

    public ClosureCodegen(@NotNull GenerationState state, @NotNull PsiElement fun, @NotNull FunctionDescriptor funDescriptor, @Nullable ClassDescriptor samInterface, @NotNull Type closureSuperClass, @NotNull CodegenContext parentContext, @NotNull LocalLookup localLookup, @NotNull FunctionGenerationStrategy strategy, @Nullable MemberCodegen parentCodegen) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (closureSuperClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closureSuperClass", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (localLookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localLookup", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/ClosureCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.fun = fun;
        this.funDescriptor = funDescriptor;
        this.samInterface = samInterface;
        this.superClass = closureSuperClass;
        this.context = parentContext.intoClosure(funDescriptor, localLookup, this.typeMapper);
        this.strategy = strategy;
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForFunction(this.bindingContext, funDescriptor);
        this.closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        assert (this.closure != null) : "Closure must be calculated for class: " + classDescriptor;
        this.asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, funDescriptor);
        this.visibilityFlag = parentContext instanceof MethodContext ? (((MethodContext)parentContext).isInlineFunction() ? 1 : 0) : 0;
    }

    public void gen() {
        String[] superInterfaces;
        FunctionDescriptor interfaceFunction;
        ClassBuilder cv = this.state.getFactory().newVisitor(this.asmType, this.fun.getContainingFile());
        if (this.samInterface == null) {
            interfaceFunction = ClosureCodegen.getInvokeFunction(this.funDescriptor);
            superInterfaces = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            interfaceFunction = SingleAbstractMethodUtils.getAbstractMethodOfSamInterface(this.samInterface);
            superInterfaces = new String[]{this.typeMapper.mapType(this.samInterface).getInternalName()};
        }
        cv.defineClass(this.fun, 50, 0x30 | this.visibilityFlag, this.asmType.getInternalName(), this.getGenericSignature(), this.superClass.getInternalName(), superInterfaces);
        cv.visitSource(this.fun.getContainingFile().getName(), null);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(this.funDescriptor).replaceName(interfaceFunction.getName().toString());
        this.generateBridge(cv, this.typeMapper.mapSignature(interfaceFunction).getAsmMethod(), jvmMethodSignature.getAsmMethod());
        FunctionCodegen fc = new FunctionCodegen(this.context, cv, this.state, this.getParentCodegen());
        fc.generateMethod(this.fun, jvmMethodSignature, this.funDescriptor, this.strategy);
        this.constructor = this.generateConstructor(cv);
        if (CodegenUtil.isConst(this.closure)) {
            this.generateConstInstance(cv);
        }
        AsmUtil.genClosureFields(this.closure, cv, this.typeMapper);
        fc.generateDefaultIfNeeded(this.context.intoFunction(this.funDescriptor), this.typeMapper.mapSignature(this.funDescriptor), this.funDescriptor, this.context.getContextKind(), DefaultParameterValueLoader.DEFAULT);
        cv.done();
    }

    @NotNull
    public StackValue putInstanceOnStack(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        if (CodegenUtil.isConst(this.closure)) {
            v.getstatic(this.asmType.getInternalName(), "instance$", this.asmType.getDescriptor());
        } else {
            v.anew(this.asmType);
            v.dup();
            codegen.pushClosureOnStack(this.closure, false, codegen.defaulCallGenerator);
            v.invokespecial(this.asmType.getInternalName(), "<init>", this.constructor.getDescriptor());
        }
        StackValue stackValue = StackValue.onStack(this.asmType);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        return stackValue;
    }

    private void generateConstInstance(@NotNull ClassBuilder cv) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstInstance"));
        }
        MethodVisitor mv = cv.newMethod(this.fun, 4104, "<clinit>", "()V", null, ArrayUtil.EMPTY_STRING_ARRAY);
        InstructionAdapter iv = new InstructionAdapter(mv);
        cv.newField(this.fun, 24, "instance$", this.asmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            iv.anew(this.asmType);
            iv.dup();
            iv.invokespecial(this.asmType.getInternalName(), "<init>", "()V");
            iv.putstatic(this.asmType.getInternalName(), "instance$", this.asmType.getDescriptor());
            mv.visitInsn(177);
            FunctionCodegen.endVisit(mv, "<clinit>", this.fun);
        }
    }

    private void generateBridge(@NotNull ClassBuilder cv, @NotNull Method bridge, @NotNull Method delegate) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateBridge"));
        }
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/jet/codegen/ClosureCodegen", "generateBridge"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/codegen/ClosureCodegen", "generateBridge"));
        }
        if (bridge.equals(delegate)) {
            return;
        }
        MethodVisitor mv = cv.newMethod(this.fun, 65, bridge.getName(), bridge.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, this.asmType);
        ReceiverParameterDescriptor receiver = this.funDescriptor.getReceiverParameter();
        int count = 1;
        if (receiver != null) {
            StackValue.local(count, bridge.getArgumentTypes()[count - 1]).put(this.typeMapper.mapType(receiver.getType()), iv);
            ++count;
        }
        List<ValueParameterDescriptor> params = this.funDescriptor.getValueParameters();
        for (ValueParameterDescriptor param : params) {
            StackValue.local(count, bridge.getArgumentTypes()[count - 1]).put(this.typeMapper.mapType(param.getType()), iv);
            ++count;
        }
        iv.invokevirtual(this.asmType.getInternalName(), delegate.getName(), delegate.getDescriptor());
        StackValue.onStack(delegate.getReturnType()).put(bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge", this.fun);
    }

    @NotNull
    private Method generateConstructor(@NotNull ClassBuilder cv) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        List<FieldInfo> args = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.closure, this.asmType);
        Method method = ClosureCodegen.generateConstructor(cv, args, this.fun, this.superClass, this.state, this.visibilityFlag);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        return method;
    }

    public static Method generateConstructor(@NotNull ClassBuilder cv, @NotNull List<FieldInfo> args, @Nullable PsiElement fun, @NotNull Type superClass, @NotNull GenerationState state, int flags) {
        if (cv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cv", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClosureCodegen", "generateConstructor"));
        }
        Type[] argTypes = ClosureCodegen.fieldListToTypeArray(args);
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = cv.newMethod(fun, flags, "<init>", constructor.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, superClass);
            iv.invokespecial(superClass.getInternalName(), "<init>", "()V");
            int k = 1;
            for (FieldInfo fieldInfo : args) {
                k = AsmUtil.genAssignInstanceFieldFromParam(fieldInfo, k, iv);
            }
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor", fun);
        }
        return constructor;
    }

    @NotNull
    public static List<FieldInfo> calculateConstructorParameters(@NotNull JetTypeMapper typeMapper, @NotNull CalculatedClosure closure, @NotNull Type ownerType) {
        JetType captureReceiverType;
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        BindingContext bindingContext = typeMapper.getBindingContext();
        ArrayList<FieldInfo> args = Lists.newArrayList();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            Type type = typeMapper.mapType(captureThis);
            args.add(FieldInfo.createForHiddenField(ownerType, type, "this$0"));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null) {
            args.add(FieldInfo.createForHiddenField(ownerType, typeMapper.mapType(captureReceiverType), "receiver$0"));
        }
        for (DeclarationDescriptor descriptor : closure.getCaptureVariables().keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = typeMapper.getSharedVarType(descriptor);
                Type type = sharedVarType != null ? sharedVarType : typeMapper.mapType((VariableDescriptor)descriptor);
                args.add(FieldInfo.createForHiddenField(ownerType, type, "$" + descriptor.getName().asString()));
                continue;
            }
            if (CodegenBinding.isLocalNamedFun(descriptor)) {
                Type classType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, (FunctionDescriptor)descriptor);
                args.add(FieldInfo.createForHiddenField(ownerType, classType, "$" + descriptor.getName().asString()));
                continue;
            }
            if (descriptor instanceof FunctionDescriptor) assert (captureReceiverType != null);
        }
        ArrayList<FieldInfo> arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        return arrayList;
    }

    private static Type[] fieldListToTypeArray(List<FieldInfo> args) {
        Type[] argTypes = new Type[args.size()];
        for (int i = 0; i != argTypes.length; ++i) {
            argTypes[i] = args.get(i).getFieldType();
        }
        return argTypes;
    }

    @NotNull
    private String getGenericSignature() {
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForFunction(this.bindingContext, this.funDescriptor);
        Collection<JetType> supertypes = classDescriptor.getTypeConstructor().getSupertypes();
        assert (supertypes.size() == 1) : "Closure must have exactly one supertype: " + this.funDescriptor;
        JetType supertype = supertypes.iterator().next();
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        sw.writeSuperclass();
        this.typeMapper.mapSupertype(supertype, sw);
        sw.writeSuperclassEnd();
        String signature = sw.makeJavaGenericSignature();
        assert (signature != null) : "Closure superclass must have a generic signature: " + this.funDescriptor;
        String string = signature;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClosureCodegen", "getGenericSignature"));
        }
        return string;
    }

    public static FunctionDescriptor getInvokeFunction(FunctionDescriptor funDescriptor) {
        int paramCount = funDescriptor.getValueParameters().size();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        ClassDescriptor funClass = funDescriptor.getReceiverParameter() == null ? builtIns.getFunction(paramCount) : builtIns.getExtensionFunction(paramCount);
        return funClass.getDefaultType().getMemberScope().getFunctions(Name.identifier("invoke")).iterator().next();
    }
}

