/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$sortBy$sortBy$8;
import kotlin.KotlinPackage-IterablesSpecial-4ef8751f;
import kotlin.KotlinPackage-Iterators-7137b0f2;
import kotlin.KotlinPackage-OrderingJVM-c145938a;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.inline;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@KotlinSyntheticClass(abiVersion=15, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class KotlinPackage-_Iterables-91c87107 {
    @inline
    public static final <T> boolean all(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!(predicate.invoke(element) == false)) continue;
            return false;
        }
        return true;
    }

    @inline
    public static final <T> boolean any(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!predicate.invoke(element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final <T> void appendString(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="buffer") @NotNull Appendable buffer, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (T element : $receiver) {
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : element.toString();
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static void appendString$default(Iterable iterable, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_Iterables-91c87107.appendString(iterable, appendable, string, string2, string3, n, string4);
    }

    @inline
    public static final <T> int count(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        for (T element : $receiver) {
            Object object2;
            if (predicate.invoke(element).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @NotNull
    public static final <T> List<T> drop(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        Iterable<T> iterable = $receiver;
        Function1 function1 = KotlinPackage-IterablesSpecial-4ef8751f.countTo(n);
        Iterable<T> iterable2 = iterable;
        List list = new ArrayList();
        boolean bl = true;
        for (T t : iterable2) {
            Object object2;
            if (!(bl ? function1.invoke(t) : false)) {
                bl = false;
                object2 = list.add(t);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return (ArrayList)list;
    }

    @inline
    @NotNull
    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterable<T> iterable = $receiver;
        List list = new ArrayList();
        boolean bl = true;
        for (T t : iterable) {
            Object object2;
            if (!(bl ? predicate.invoke(t) : false)) {
                bl = false;
                object2 = list.add(t);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return (ArrayList)list;
    }

    @inline
    @NotNull
    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull L result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        for (T element : $receiver) {
            Object object2;
            if (!(start != 0 ? predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T> List<T> filter(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterable<T> iterable = $receiver;
        Collection collection = new ArrayList();
        for (T t : iterable) {
            Object object2 = predicate.invoke(t) != false ? Boolean.valueOf(collection.add(t)) : Unit.VALUE;
        }
        return (ArrayList)collection;
    }

    @inline
    @NotNull
    public static final <T> List<T> filterNot(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterable<T> iterable = $receiver;
        Collection collection = new ArrayList();
        for (T t : iterable) {
            Object object2 = predicate.invoke(t) == false ? Boolean.valueOf(collection.add(t)) : Unit.VALUE;
        }
        return (ArrayList)collection;
    }

    @NotNull
    public static final <T> List<T> filterNotNull(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_Iterables-91c87107.filterNotNullTo($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (T element : $receiver) {
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            Object object2 = predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @Nullable
    public static final <T> T find(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!predicate.invoke(element).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @inline
    @NotNull
    public static final <T, R> List<R> flatMap(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        Iterable<T> iterable = $receiver;
        Collection collection = new ArrayList();
        for (T t : iterable) {
            Iterable<R> iterable2 = transform.invoke(t);
            for (R r : iterable2) {
                collection.add(r);
            }
        }
        return (ArrayList)collection;
    }

    @inline
    @NotNull
    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        for (T element : $receiver) {
            Iterable<R> list = transform.invoke(element);
            for (R r : list) {
                result.add(r);
            }
        }
        return result;
    }

    @inline
    public static final <T, R> R fold(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="initial") R initial, @JetValueParameter(name="operation") @NotNull Function2<? super R, ? super T, ? extends R> operation) {
        R answer = initial;
        for (T element : $receiver) {
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    @inline
    @NotNull
    public static final <T> void forEach(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super T, ? extends Unit> operation) {
        for (T element : $receiver) {
            operation.invoke(element);
        }
    }

    @inline
    @NotNull
    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        Iterable<T> iterable = $receiver;
        Map map = new HashMap();
        Iterator<T> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Map map2 = map;
            T t = iterator2.next();
            K k = toKey.invoke(t);
            if (map2.containsKey(k)) {
                object2 = map2.get(k);
            } else {
                ArrayList arrayList = new ArrayList();
                map2.put(k, arrayList);
                object2 = arrayList;
            }
            List list = (List)object2;
            list.add(t);
        }
        return map;
    }

    @inline
    @NotNull
    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull Map<K, List<T>> result, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        Iterator<T> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            ArrayList arrayList;
            Map<K, List<T>> map = result;
            T element = iterator2.next();
            K key = toKey.invoke(element);
            if (map.containsKey(key)) {
                arrayList = (ArrayList)map.get(key);
            } else {
                ArrayList arrayList2 = new ArrayList();
                map.put(key, arrayList2);
                arrayList = arrayList2;
            }
            List list = arrayList;
            list.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> String makeString(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_Iterables-91c87107.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static String makeString$default(Iterable iterable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_Iterables-91c87107.makeString(iterable, string, string2, string3, n, string4);
    }

    @inline
    @NotNull
    public static final <T, R> List<R> map(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        Iterable<T> iterable = $receiver;
        Collection collection = new ArrayList();
        for (T t : iterable) {
            collection.add(transform.invoke(t));
        }
        return (ArrayList)collection;
    }

    @inline
    @NotNull
    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        for (T item : $receiver) {
            result.add(transform.invoke(item));
        }
        return result;
    }

    @Nullable
    public static final <T extends Comparable<? super T>> T max(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            return (T)((Comparable)null);
        }
        Comparable max = (Comparable)iterator2.next();
        while (iterator2.hasNext()) {
            Comparable e = (Comparable)iterator2.next();
            if (max.compareTo(e) >= 0) continue;
            max = e;
        }
        return (T)max;
    }

    @inline
    @Nullable
    public static final <R extends Comparable<? super R>, T> T maxBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        T maxElem = iterator2.next();
        Comparable maxValue = (Comparable)f.invoke(maxElem);
        while (iterator2.hasNext()) {
            T e = iterator2.next();
            Comparable v = (Comparable)f.invoke(e);
            if (maxValue.compareTo(v) >= 0) continue;
            maxElem = e;
            maxValue = v;
        }
        return maxElem;
    }

    @Nullable
    public static final <T extends Comparable<? super T>> T min(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            return (T)((Comparable)null);
        }
        Comparable min = (Comparable)iterator2.next();
        while (iterator2.hasNext()) {
            Comparable e = (Comparable)iterator2.next();
            if (min.compareTo(e) <= 0) continue;
            min = e;
        }
        return (T)min;
    }

    @inline
    @Nullable
    public static final <R extends Comparable<? super R>, T> T minBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        T minElem = iterator2.next();
        Comparable minValue = (Comparable)f.invoke(minElem);
        while (iterator2.hasNext()) {
            T e = iterator2.next();
            Comparable v = (Comparable)f.invoke(e);
            if (minValue.compareTo(v) <= 0) continue;
            minElem = e;
            minValue = v;
        }
        return minElem;
    }

    @inline
    @NotNull
    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        for (T element : $receiver) {
            boolean bl = predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="collection") @NotNull Iterable<? extends T> collection) {
        return KotlinPackage-_Iterables-91c87107.plus($receiver, collection.iterator());
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="element") T element) {
        ArrayList<T> answer = new ArrayList<T>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)answer);
        answer.add(element);
        return answer;
    }

    @NotNull
    public static final <T> List<T> plus(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="iterator") @NotNull Iterator<? extends T> iterator2) {
        ArrayList<T> answer = new ArrayList<T>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)answer);
        Iterator<T> iterator3 = KotlinPackage-Iterators-7137b0f2.iterator(iterator2);
        while (iterator3.hasNext()) {
            T element = iterator3.next();
            answer.add(element);
        }
        return answer;
    }

    @inline
    public static final <T> T reduce(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = $receiver.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        T result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    @NotNull
    public static final <T> Iterable<T> requireNoNulls(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        for (T element : $receiver) {
            boolean bl = true;
            if (element != null) {
                bl = false;
            }
            if (!bl) continue;
            throw (Throwable)new IllegalArgumentException("null element found in " + $receiver);
        }
        Iterable<T> iterable = $receiver;
        if (iterable == null) {
            throw new TypeCastException("kotlin.Iterable<T?> cannot be cast to kotlin.Iterable<T>");
        }
        return iterable;
    }

    @NotNull
    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        ArrayList list = (ArrayList)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list);
        return list;
    }

    @inline
    @NotNull
    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-c145938a.comparator(new KotlinPackage$sortBy$sortBy$8(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @NotNull
    public static final <T> List<T> take(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        Iterable<T> iterable = $receiver;
        Function1 function1 = KotlinPackage-IterablesSpecial-4ef8751f.countTo(n);
        Iterable<T> iterable2 = iterable;
        Collection collection = new ArrayList();
        for (T t : iterable2) {
            if (!function1.invoke(t).booleanValue()) break;
            collection.add(t);
        }
        return (ArrayList)collection;
    }

    @inline
    @NotNull
    public static final <T> List<T> takeWhile(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterable<T> iterable = $receiver;
        Collection collection = new ArrayList();
        for (T t : iterable) {
            if (!predicate.invoke(t).booleanValue()) break;
            collection.add(t);
        }
        return (ArrayList)collection;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        for (T element : $receiver) {
            if (!predicate.invoke(element).booleanValue()) break;
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result) {
        for (T element : $receiver) {
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (LinkedList)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)new LinkedList());
    }

    @NotNull
    public static final <T> List<T> toList(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (LinkedHashSet)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @NotNull
    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return (TreeSet)KotlinPackage-_Iterables-91c87107.toCollection($receiver, (Collection)new TreeSet());
    }

    @NotNull
    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver") Iterable<? extends T> $receiver) {
        return new IndexIterator<T>($receiver.iterator());
    }

    public static final int sum(@JetValueParameter(name="$receiver") Iterable<? extends Integer> $receiver) {
        Integer n;
        Iterable<? extends Integer> iterable = $receiver;
        Integer n2 = n = Integer.valueOf(0);
        for (Integer n3 : iterable) {
            int n4 = ((Number)n3).intValue();
            int n5 = ((Number)n2).intValue();
            n2 = n5 + n4;
        }
        return ((Number)n2).intValue();
    }

    public static final long sum(@JetValueParameter(name="$receiver") Iterable<? extends Long> $receiver) {
        Long l;
        Iterable<? extends Long> iterable = $receiver;
        Long l2 = l = Long.valueOf(0);
        for (Long l3 : iterable) {
            long l4 = ((Number)l3).longValue();
            long l5 = ((Number)l2).longValue();
            l2 = l5 + l4;
        }
        return ((Number)l2).longValue();
    }

    public static final float sum(@JetValueParameter(name="$receiver") Iterable<? extends Float> $receiver) {
        Float f;
        Iterable<? extends Float> iterable = $receiver;
        Float f2 = f = Float.valueOf(0.0f);
        for (Float f3 : iterable) {
            float f4 = ((Number)f3).floatValue();
            float f5 = ((Number)f2).floatValue();
            f2 = Float.valueOf(f5 + f4);
        }
        return ((Number)f2).floatValue();
    }

    public static final double sum(@JetValueParameter(name="$receiver") Iterable<? extends Double> $receiver) {
        Double d;
        Iterable<? extends Double> iterable = $receiver;
        Double d2 = d = Double.valueOf(0.0);
        for (Double d3 : iterable) {
            double d4 = ((Number)d3).doubleValue();
            double d5 = ((Number)d2).doubleValue();
            d2 = d5 + d4;
        }
        return ((Number)d2).doubleValue();
    }
}

