/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharArrayUtil {
    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset, int len) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (src instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i = buffer.position();
                buffer.position(i + srcOffset);
                buffer.get(dst, dstOffset, len);
                buffer.position(i);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(srcOffset, srcOffset + len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
        }
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = src.charAt(j);
        }
    }

    @Nullable
    public static char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        char[] underlying = CharArrayUtil.fromSequenceWithoutCopying(seq);
        char[] cArray = underlying != null ? Arrays.copyOf(underlying, underlying.length) : CharArrayUtil.fromSequence(seq, 0, seq.length());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        return cArray;
    }

    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq, int start, int end) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        char[] result = new char[end - start];
        CharArrayUtil.getChars(seq, result, start, 0, end - start);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        return result;
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        int limit = Math.min(endOffset, buffer.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "shiftBackwardUntil"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/text/CharArrayUtil", "shiftBackwardUntil"));
        }
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int offset, @NotNull CharSequence s) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (offset + s.length() > buffer.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnlyWhiteSpaces(@Nullable CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharArrayUtil", "containLineBreaks"));
        }
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }
}

