/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.IntLCS;
import com.intellij.util.diff.UniqueLCS;
import java.util.BitSet;

public class PatienceIntLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final int myCount1;
    private final int myCount2;
    private final BitSet myChanges1;
    private final BitSet myChanges2;

    public PatienceIntLCS(int[] first, int[] second) {
        this(first, second, 0, first.length, 0, second.length, new BitSet(first.length), new BitSet(second.length));
    }

    public PatienceIntLCS(int[] first, int[] second, int start1, int count1, int start2, int count2, BitSet changes1, BitSet changes2) {
        this.myFirst = first;
        this.mySecond = second;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myCount1 = count1;
        this.myCount2 = count2;
        this.myChanges1 = changes1;
        this.myChanges2 = changes2;
    }

    public void execute() throws FilesTooBigForDiffException {
        if (this.myCount1 == 0 && this.myCount2 == 0) {
            return;
        }
        if (this.myCount1 == 0 || this.myCount2 == 0) {
            this.addChange(this.myStart1, this.myCount1, this.myStart2, this.myCount2);
            return;
        }
        int startOffset = this.matchForward(this.myStart1, this.myStart2);
        int start1 = this.myStart1 + startOffset;
        int start2 = this.myStart2 + startOffset;
        int endOffset = this.matchBackward(this.myStart1 + this.myCount1 - 1, this.myStart2 + this.myCount2 - 1, start1, start2);
        int count1 = this.myCount1 - startOffset - endOffset;
        int count2 = this.myCount2 - startOffset - endOffset;
        if (count1 == 0 || count2 == 0) {
            this.addChange(start1, count1, start2, count2);
        } else {
            UniqueLCS uniqueLCS = new UniqueLCS(this.myFirst, this.mySecond, start1, count1, start2, count2);
            int[][] matching = uniqueLCS.execute();
            if (matching == null) {
                IntLCS intLCS = new IntLCS(this.myFirst, this.mySecond, start1, count1, start2, count2, this.myChanges1, this.myChanges2);
                intLCS.execute();
            } else {
                int c2;
                int c1;
                int s2;
                int s1;
                int matched = matching[0].length;
                assert (matched > 0);
                PatienceIntLCS patienceDiff = new PatienceIntLCS(this.myFirst, this.mySecond, start1, matching[0][0], start2, matching[1][0], this.myChanges1, this.myChanges2);
                patienceDiff.execute();
                for (int i = 1; i < matching[0].length; ++i) {
                    s1 = matching[0][i - 1] + 1;
                    s2 = matching[1][i - 1] + 1;
                    c1 = matching[0][i] - s1;
                    c2 = matching[1][i] - s2;
                    if (c1 <= 0 && c2 <= 0) continue;
                    patienceDiff = new PatienceIntLCS(this.myFirst, this.mySecond, start1 + s1, c1, start2 + s2, c2, this.myChanges1, this.myChanges2);
                    patienceDiff.execute();
                }
                if (matching[0][matched - 1] == count1 - 1) {
                    s1 = count1 - 1;
                    c1 = 0;
                } else {
                    s1 = matching[0][matched - 1] + 1;
                    c1 = count1 - s1;
                }
                if (matching[1][matched - 1] == count2 - 1) {
                    s2 = count2 - 1;
                    c2 = 0;
                } else {
                    s2 = matching[1][matched - 1] + 1;
                    c2 = count2 - s2;
                }
                patienceDiff = new PatienceIntLCS(this.myFirst, this.mySecond, start1 + s1, c1, start2 + s2, c2, this.myChanges1, this.myChanges2);
                patienceDiff.execute();
            }
        }
    }

    private int matchForward(int offset1, int offset2) {
        int size = Math.min(this.myCount1 - offset1, this.myCount2 - offset2);
        int idx = 0;
        for (int i = 0; i < size && this.myFirst[offset1 + i] == this.mySecond[offset2 + i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private int matchBackward(int offset1, int offset2, int processedOffset1, int processedOffset2) {
        int size = Math.min(offset1 - processedOffset1 - 1, offset2 - processedOffset2 - 1);
        int idx = 0;
        for (int i = 0; i < size && this.myFirst[offset1 - i] == this.mySecond[offset2 - i]; ++i) {
            ++idx;
        }
        return idx;
    }

    public void addChange(int start1, int count1, int start2, int count2) {
        this.myChanges1.set(start1, start1 + count1);
        this.myChanges2.set(start2, start2 + count2);
    }

    public BitSet[] getChanges() {
        return new BitSet[]{this.myChanges1, this.myChanges2};
    }
}

