/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MostlySingularMultiMap<K, V>
implements Serializable {
    protected final Map<K, Object> myMap = this.createMap();
    private static final MostlySingularMultiMap EMPTY = new EmptyMap();

    @NotNull
    protected Map<K, Object> createMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "createMap"));
        }
        return tHashMap;
    }

    public void add(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/MostlySingularMultiMap", "add"));
        }
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value);
        } else if (current instanceof Object[]) {
            Object[] curArr = (Object[])current;
            Object[] newArr = ArrayUtil.append(curArr, value, ArrayUtil.OBJECT_ARRAY_FACTORY);
            this.myMap.put(key, newArr);
        } else {
            this.myMap.put(key, new Object[]{current, value});
        }
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public boolean processForKey(@NotNull K key, @NotNull Processor<V> p) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap", "processForKey"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/MostlySingularMultiMap", "processForKey"));
        }
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<V> p, Object v) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap", "processValue"));
        }
        if (v instanceof Object[]) {
            for (Object o : (Object[])v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(@NotNull Processor<V> p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap", "processAllValues"));
        }
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Iterable<V> get(@NotNull K name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap", "get"));
        }
        Object value = this.myMap.get(name);
        List<V> list = this.rawValueToCollection(value);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "get"));
        }
        return list;
    }

    @NotNull
    protected List<V> rawValueToCollection(Object value) {
        if (value == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "rawValueToCollection"));
            }
            return list;
        }
        if (value instanceof Object[]) {
            List<Object> list = Arrays.asList((Object[])value);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "rawValueToCollection"));
            }
            return list;
        }
        List<Object> list = Collections.singletonList(value);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "rawValueToCollection"));
        }
        return list;
    }

    public void compact() {
        ((THashMap)this.myMap).compact();
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), new Function<Map.Entry<K, Object>, String>(){

            @Override
            public String fun(Map.Entry<K, Object> entry) {
                Object value = entry.getValue();
                String s = (value instanceof Object[] ? Arrays.asList((Object[])value) : Arrays.asList(value)).toString();
                return entry.getKey() + ": " + s;
            }
        }, "; ") + "}";
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> emptyMap() {
        MostlySingularMultiMap mostlySingularMultiMap = EMPTY;
        if (mostlySingularMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "emptyMap"));
        }
        return mostlySingularMultiMap;
    }

    private static class EmptyMap
    extends MostlySingularMultiMap {
        private EmptyMap() {
        }

        public void add(@NotNull Object key, @NotNull Object value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "add"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "add"));
            }
            throw new IncorrectOperationException();
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean processForKey(@NotNull Object key, @NotNull Processor p) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "processForKey"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "processForKey"));
            }
            return true;
        }

        public boolean processAllValues(@NotNull Processor p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "processAllValues"));
            }
            return true;
        }

        @NotNull
        public Iterable get(@NotNull Object name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "get"));
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "get"));
            }
            return list;
        }
    }
}

