/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeElement
extends ElementBase
implements ASTNode,
Cloneable {
    public static final TreeElement[] EMPTY_ARRAY = new TreeElement[0];
    private TreeElement myNextSibling = null;
    private TreeElement myPrevSibling = null;
    private CompositeElement myParent = null;
    private final IElementType myType;
    private volatile int myStartOffsetInParent = -1;

    public TreeElement(IElementType type) {
        this.myType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        TreeElement clone = (TreeElement)super.clone();
        Object object2 = PsiLock.LOCK;
        synchronized (object2) {
            clone.myNextSibling = null;
            clone.myPrevSibling = null;
            clone.myParent = null;
            clone.myStartOffsetInParent = -1;
        }
        return clone;
    }

    @Override
    public ASTNode copyElement() {
        CharTable table = SharedImplUtil.findCharTableByTree(this);
        return ChangeUtil.copyElement(this, table);
    }

    public PsiManagerEx getManager() {
        TreeElement element = this;
        while (element.getTreeParent() != null) {
            element = element.getTreeParent();
        }
        if (element instanceof FileElement) {
            return element.getManager();
        }
        if (this.getTreeParent() != null) {
            return this.getTreeParent().getManager();
        }
        return null;
    }

    @Override
    public abstract LeafElement findLeafElementAt(int var1);

    @NotNull
    public abstract char[] textToCharArray();

    @Override
    public abstract TreeElement getFirstChildNode();

    @Override
    public abstract TreeElement getLastChildNode();

    public abstract int getNotCachedLength();

    public abstract int getCachedLength();

    @Override
    public TextRange getTextRange() {
        int start = this.getStartOffset();
        return new TextRange(start, start + this.getTextLength());
    }

    @Override
    public int getStartOffset() {
        int result = 0;
        TreeElement current = this;
        while (current.myParent != null) {
            result += current.getStartOffsetInParent();
            current = current.myParent;
        }
        return result;
    }

    public final int getStartOffsetInParent() {
        TreeElement prev;
        if (this.myParent == null) {
            return -1;
        }
        int offsetInParent = this.myStartOffsetInParent;
        if (offsetInParent != -1) {
            return offsetInParent;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TreeElement cur = this;
        while ((prev = cur.getTreePrev()) != null) {
            cur = prev;
            offsetInParent = cur.myStartOffsetInParent;
            if (offsetInParent == -1) continue;
            break;
        }
        if (offsetInParent == -1) {
            offsetInParent = 0;
            cur.myStartOffsetInParent = 0;
        }
        while (cur != this) {
            TreeElement next = cur.getTreeNext();
            next.myStartOffsetInParent = offsetInParent += cur.getTextLength();
            cur = next;
        }
        return offsetInParent;
    }

    public int getTextOffset() {
        return this.getStartOffset();
    }

    public boolean textMatches(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/TreeElement", "textMatches"));
        }
        return this.textMatches(buffer, startOffset) == endOffset;
    }

    protected abstract int textMatches(@NotNull CharSequence var1, int var2);

    public boolean textMatches(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/TreeElement", "textMatches"));
        }
        return this.textMatches(seq, 0, seq.length());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/TreeElement", "textMatches"));
        }
        return this.getTextLength() == element.getTextLength() && this.textMatches(element.getText());
    }

    @NonNls
    public String toString() {
        return "Element(" + this.getElementType().toString() + ")";
    }

    @Override
    public final CompositeElement getTreeParent() {
        return this.myParent;
    }

    @Override
    public final TreeElement getTreePrev() {
        return this.myPrevSibling;
    }

    final void setTreeParent(CompositeElement parent) {
        this.myParent = parent;
        if (parent != null && parent.getElementType() != TokenType.DUMMY_HOLDER) {
            DebugUtil.revalidateNode(this);
        }
    }

    final void setTreePrev(TreeElement prev) {
        this.myPrevSibling = prev;
        TreeElement.clearRelativeOffsets(this);
    }

    @Override
    public final TreeElement getTreeNext() {
        return this.myNextSibling;
    }

    final void setTreeNext(TreeElement next) {
        this.myNextSibling = next;
        TreeElement.clearRelativeOffsets(next);
    }

    protected static void clearRelativeOffsets(TreeElement element) {
        for (TreeElement cur = element; cur != null && cur.myStartOffsetInParent != -1; cur = cur.getTreeNext()) {
            cur.myStartOffsetInParent = -1;
        }
    }

    public void clearCaches() {
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public abstract int hc();

    public abstract void acceptTree(TreeElementVisitor var1);

    protected void onInvalidated() {
        DebugUtil.onInvalidated(this);
    }

    public void rawInsertBeforeMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/TreeElement", "rawInsertBeforeMe"));
        }
        TreeElement anchorPrev = this.getTreePrev();
        if (anchorPrev == null) {
            firstNew.rawRemoveUpToLast();
            CompositeElement p = this.getTreeParent();
            if (p != null) {
                p.setFirstChildNode(firstNew);
            }
            while (true) {
                TreeElement treeNext = firstNew.getTreeNext();
                assert (treeNext != this) : "Attempt to create cycle";
                firstNew.setTreeParent(p);
                if (treeNext == null) break;
                firstNew = treeNext;
            }
            this.setTreePrev(firstNew);
            firstNew.setTreeNext(this);
            if (p != null) {
                p.subtreeChanged();
            }
        } else {
            anchorPrev.rawInsertAfterMe(firstNew);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawInsertAfterMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/TreeElement", "rawInsertAfterMe"));
        }
        this.rawInsertAfterMeWithoutNotifications(firstNew);
        CompositeElement parent = this.getTreeParent();
        if (parent != null) {
            parent.subtreeChanged();
        }
    }

    protected final void rawInsertAfterMeWithoutNotifications(TreeElement firstNew) {
        firstNew.rawRemoveUpToWithoutNotifications(null, false);
        CompositeElement p = this.getTreeParent();
        TreeElement treeNext = this.getTreeNext();
        firstNew.setTreePrev(this);
        this.setTreeNext(firstNew);
        while (true) {
            TreeElement n = firstNew.getTreeNext();
            assert (n != this) : "Attempt to create cycle";
            firstNew.setTreeParent(p);
            if (n == null) break;
            firstNew = n;
        }
        if (treeNext == null) {
            if (p != null) {
                firstNew.setTreeParent(p);
                p.setLastChildNode(firstNew);
            }
        } else {
            firstNew.setTreeNext(treeNext);
            treeNext.setTreePrev(firstNew);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemove() {
        TreeElement next = this.getTreeNext();
        CompositeElement parent = this.getTreeParent();
        TreeElement prev = this.getTreePrev();
        if (prev != null) {
            prev.setTreeNext(next);
        } else if (parent != null) {
            parent.setFirstChildNode(next);
        }
        if (next != null) {
            next.setTreePrev(prev);
        } else if (parent != null) {
            parent.setLastChildNode(prev);
        }
        DebugUtil.checkTreeStructure(parent);
        DebugUtil.checkTreeStructure(prev);
        DebugUtil.checkTreeStructure(next);
        this.invalidate();
    }

    public void rawReplaceWithList(TreeElement firstNew) {
        if (firstNew != null) {
            this.rawInsertAfterMeWithoutNotifications(firstNew);
        }
        this.rawRemove();
    }

    protected void invalidate() {
        CompositeElement parent = this.getTreeParent();
        if (parent != null) {
            parent.subtreeChanged();
        }
        this.onInvalidated();
        this.setTreeNext(null);
        this.setTreePrev(null);
        this.setTreeParent(null);
    }

    public void rawRemoveUpToLast() {
        this.rawRemoveUpTo(null);
    }

    public void rawRemoveUpTo(@Nullable TreeElement end) {
        CompositeElement parent = this.getTreeParent();
        this.rawRemoveUpToWithoutNotifications(end, true);
        if (parent != null) {
            parent.subtreeChanged();
        }
    }

    protected final void rawRemoveUpToWithoutNotifications(TreeElement end, boolean invalidate) {
        TreeElement element;
        TreeElement endPrev;
        if (this == end) {
            return;
        }
        CompositeElement parent = this.getTreeParent();
        TreeElement startPrev = this.getTreePrev();
        TreeElement treeElement = endPrev = end != null ? end.getTreePrev() : null;
        assert (end == null || end.getTreeParent() == parent) : "Trying to remove non-child";
        if (end != null) {
            for (element = this; element != end && element != null; element = element.getTreeNext()) {
            }
            assert (element == end) : end + " is not successor of " + this + " in the .getTreeNext() chain";
        }
        if (parent != null) {
            if (this == parent.getFirstChildNode()) {
                parent.setFirstChildNode(end);
            }
            if (end == null) {
                parent.setLastChildNode(startPrev);
            }
        }
        if (startPrev != null) {
            startPrev.setTreeNext(end);
        }
        if (end != null) {
            end.setTreePrev(startPrev);
        }
        this.setTreePrev(null);
        if (endPrev != null) {
            endPrev.setTreeNext(null);
        }
        if (parent != null) {
            for (element = this; element != null; element = element.getTreeNext()) {
                element.setTreeParent(null);
                if (!invalidate) continue;
                element.onInvalidated();
            }
        }
        DebugUtil.checkTreeStructure(parent);
        DebugUtil.checkTreeStructure(this);
    }

    @Override
    public IElementType getElementType() {
        return this.myType;
    }
}

