/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MockFileIndexFacade
extends FileIndexFacade {
    private final Module myModule = null;
    private final List<VirtualFile> myLibraryRoots = new ArrayList<VirtualFile>();

    public MockFileIndexFacade(Project project) {
        super(project);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "isInContent"));
        }
        return true;
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "isInSource"));
        }
        return true;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "isInSourceContent"));
        }
        return true;
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "isInLibraryClasses"));
        }
        for (VirtualFile libraryRoot : this.myLibraryRoots) {
            if (!VfsUtilCore.isAncestor(libraryRoot, file, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "isInLibrarySource"));
        }
        return false;
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "isExcludedFile"));
        }
        return false;
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileIndexFacade", "getModuleForFile"));
        }
        return this.myModule;
    }

    @Override
    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileIndexFacade", "getRootModificationTracker"));
        }
        return modificationTracker;
    }

    public void addLibraryRoot(VirtualFile file) {
        this.myLibraryRoots.add(file);
    }
}

