/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.Maps;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsScope {
    @Nullable
    private final String description;
    private Map<String, JsName> names = Collections.emptyMap();
    private final JsScope parent;
    protected int tempIndex = 0;
    private final String scopeId;

    public JsScope(JsScope parent, @Nullable String description) {
        this(parent, description, null);
    }

    public JsScope(JsScope parent, @Nullable String description, @Nullable String scopeId) {
        assert (parent != null);
        this.scopeId = scopeId;
        this.description = description;
        this.parent = parent;
    }

    @NotNull
    public JsScope innerScope(@Nullable String scopeName) {
        JsScope jsScope = new JsScope(this, scopeName);
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "innerScope"));
        }
        return jsScope;
    }

    protected JsScope(@Nullable String description) {
        this.description = description;
        this.parent = null;
        this.scopeId = null;
    }

    public JsName declareName(String identifier) {
        JsName name = this.findOwnName(identifier);
        return name != null ? name : this.doCreateName(identifier);
    }

    @NotNull
    public JsName declareFreshName(String suggestedName) {
        String name = suggestedName;
        int counter = 0;
        while (this.hasOwnName(name)) {
            name = suggestedName + '_' + counter++;
        }
        JsName jsName = this.doCreateName(name);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "declareFreshName"));
        }
        return jsName;
    }

    private String getNextTempName() {
        return "tmp$" + (this.scopeId != null ? this.scopeId + "$" : "") + this.tempIndex++;
    }

    public JsName declareTemporary() {
        return this.declareFreshName(this.getNextTempName());
    }

    @Nullable
    public final JsName findName(String ident) {
        JsName name = this.findOwnName(ident);
        if (name == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name;
    }

    protected boolean hasOwnName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/google/dart/compiler/backend/js/ast/JsScope", "hasOwnName"));
        }
        return this.names.containsKey(name);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    protected JsName doCreateName(String ident) {
        JsName name = new JsName(this, ident);
        this.names = Maps.put(this.names, ident, name);
        return name;
    }

    protected JsName findOwnName(String ident) {
        return this.names.get(ident);
    }
}

