/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.EmptyImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.RegularImmutableBiMap;
import com.google.common.collect.SingletonImmutableBiMap;
import java.util.Collection;
import java.util.Map;

public abstract class ImmutableBiMap<K, V>
extends ImmutableMap<K, V>
implements BiMap<K, V> {
    public static <K, V> ImmutableBiMap<K, V> of() {
        return EmptyImmutableBiMap.INSTANCE;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1) {
        Preconditions.checkNotNull(k1, "null key in entry: null=%s", v1);
        Preconditions.checkNotNull(v1, "null value in entry: %s=null", k1);
        return new SingletonImmutableBiMap<K, V>(k1, v1);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> ImmutableBiMap<K, V> fromEntries(Collection<? extends Map.Entry<? extends K, ? extends V>> entries) {
        switch (entries.size()) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry<K, V> entry = Iterables.getOnlyElement(entries);
                return new SingletonImmutableBiMap<K, V>(entry.getKey(), entry.getValue());
            }
        }
        return new RegularImmutableBiMap(entries);
    }

    ImmutableBiMap() {
    }

    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return this.inverse().keySet();
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            return ImmutableBiMap.fromEntries(this.entries);
        }
    }
}

