/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class ReturnNoValueInstruction
extends AbstractJumpInstruction
implements ReturnInstruction {
    private final JetElement element;

    public ReturnNoValueInstruction(@NotNull JetElement element, LexicalScope lexicalScope, Label targetLabel) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "<init>"));
        }
        super(targetLabel, lexicalScope);
        this.element = element;
    }

    @Override
    @NotNull
    public JetElement getElement() {
        JetElement jetElement = this.element;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "getElement"));
        }
        return jetElement;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "accept"));
        }
        visitor.visitReturnNoValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "accept"));
        }
        return visitor.visitReturnNoValue(this);
    }

    public String toString() {
        return "ret " + this.getTargetLabel();
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel, @NotNull LexicalScope lexicalScope) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLabel", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "createCopy"));
        }
        if (lexicalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScope", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "createCopy"));
        }
        return new ReturnNoValueInstruction(this.element, lexicalScope, newLabel);
    }
}

