/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinderImpl;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.lazy.GlobalJavaResolverContext;
import org.jetbrains.jet.lang.resolve.java.lazy.LazyJavaPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.java.resolver.PsiBasedExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PsiBasedMethodSignatureChecker;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedJavaResolverCache;
import org.jetbrains.jet.lang.resolve.kotlin.AnnotationDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.kotlin.ConstantDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorDeserializers;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorDeserializersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class InjectorForJavaDescriptorResolver {
    private final Project project;
    private final BindingTrace bindingTrace;
    private final GlobalContextImpl globalContext;
    private final LockBasedStorageManager lockBasedStorageManager;
    private final ModuleDescriptorImpl module;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final JavaClassFinderImpl javaClassFinder;
    private final TraceBasedExternalSignatureResolver traceBasedExternalSignatureResolver;
    private final TraceBasedJavaResolverCache traceBasedJavaResolverCache;
    private final TraceBasedErrorReporter traceBasedErrorReporter;
    private final PsiBasedMethodSignatureChecker psiBasedMethodSignatureChecker;
    private final PsiBasedExternalAnnotationResolver psiBasedExternalAnnotationResolver;
    private final VirtualFileFinder virtualFileFinder;
    private final LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider;
    private final GlobalJavaResolverContext globalJavaResolverContext;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final DescriptorDeserializers descriptorDeserializers;
    private final AnnotationDescriptorDeserializer annotationDescriptorDeserializer;
    private final DescriptorDeserializersStorage descriptorDeserializersStorage;
    private final ConstantDescriptorDeserializer constantDescriptorDeserializer;

    public InjectorForJavaDescriptorResolver(@NotNull Project project, @NotNull BindingTrace bindingTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        this.project = project;
        this.bindingTrace = bindingTrace;
        this.globalContext = ContextPackage.GlobalContext();
        this.lockBasedStorageManager = this.globalContext.getStorageManager();
        this.module = AnalyzerFacadeForJVM.createJavaModule("<fake-jdr-module>");
        this.javaClassFinder = new JavaClassFinderImpl();
        this.virtualFileFinder = VirtualFileFinder.SERVICE.getInstance(project);
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver();
        this.psiBasedExternalAnnotationResolver = new PsiBasedExternalAnnotationResolver();
        this.traceBasedExternalSignatureResolver = new TraceBasedExternalSignatureResolver();
        this.traceBasedErrorReporter = new TraceBasedErrorReporter();
        this.psiBasedMethodSignatureChecker = new PsiBasedMethodSignatureChecker();
        this.traceBasedJavaResolverCache = new TraceBasedJavaResolverCache();
        this.globalJavaResolverContext = new GlobalJavaResolverContext(this.lockBasedStorageManager, this.getJavaClassFinder(), this.virtualFileFinder, this.deserializedDescriptorResolver, this.psiBasedExternalAnnotationResolver, this.traceBasedExternalSignatureResolver, this.traceBasedErrorReporter, this.psiBasedMethodSignatureChecker, this.traceBasedJavaResolverCache);
        this.lazyJavaPackageFragmentProvider = new LazyJavaPackageFragmentProvider(this.globalJavaResolverContext, this.getModule());
        this.javaDescriptorResolver = new JavaDescriptorResolver(this.lazyJavaPackageFragmentProvider, this.getModule());
        this.descriptorDeserializers = new DescriptorDeserializers();
        this.annotationDescriptorDeserializer = new AnnotationDescriptorDeserializer();
        this.descriptorDeserializersStorage = new DescriptorDeserializersStorage(this.lockBasedStorageManager);
        this.constantDescriptorDeserializer = new ConstantDescriptorDeserializer();
        this.javaClassFinder.setProject(project);
        this.traceBasedExternalSignatureResolver.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.traceBasedExternalSignatureResolver.setTrace(bindingTrace);
        this.traceBasedJavaResolverCache.setTrace(bindingTrace);
        this.traceBasedErrorReporter.setTrace(bindingTrace);
        this.psiBasedMethodSignatureChecker.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.psiBasedMethodSignatureChecker.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.deserializedDescriptorResolver.setAnnotationDeserializer(this.descriptorDeserializers);
        this.deserializedDescriptorResolver.setErrorReporter(this.traceBasedErrorReporter);
        this.deserializedDescriptorResolver.setJavaDescriptorResolver(this.javaDescriptorResolver);
        this.deserializedDescriptorResolver.setJavaPackageFragmentProvider(this.lazyJavaPackageFragmentProvider);
        this.deserializedDescriptorResolver.setStorageManager(this.lockBasedStorageManager);
        this.descriptorDeserializers.setAnnotationDescriptorDeserializer(this.annotationDescriptorDeserializer);
        this.descriptorDeserializers.setConstantDescriptorDeserializer(this.constantDescriptorDeserializer);
        this.annotationDescriptorDeserializer.setClassResolver(this.javaDescriptorResolver);
        this.annotationDescriptorDeserializer.setErrorReporter(this.traceBasedErrorReporter);
        this.annotationDescriptorDeserializer.setKotlinClassFinder(this.virtualFileFinder);
        this.annotationDescriptorDeserializer.setStorage(this.descriptorDeserializersStorage);
        this.descriptorDeserializersStorage.setClassResolver(this.javaDescriptorResolver);
        this.descriptorDeserializersStorage.setErrorReporter(this.traceBasedErrorReporter);
        this.constantDescriptorDeserializer.setClassResolver(this.javaDescriptorResolver);
        this.constantDescriptorDeserializer.setErrorReporter(this.traceBasedErrorReporter);
        this.constantDescriptorDeserializer.setKotlinClassFinder(this.virtualFileFinder);
        this.constantDescriptorDeserializer.setStorage(this.descriptorDeserializersStorage);
        this.javaClassFinder.initialize();
    }

    @PreDestroy
    public void destroy() {
    }

    public GlobalContextImpl getGlobalContext() {
        return this.globalContext;
    }

    public ModuleDescriptorImpl getModule() {
        return this.module;
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }

    public JavaClassFinderImpl getJavaClassFinder() {
        return this.javaClassFinder;
    }
}

