/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.jvm.compiler.ClassPath;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinBinaryClassCache;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClassFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class CliVirtualFileFinder
extends VirtualFileKotlinClassFinder
implements VirtualFileFinder {
    @NotNull
    private final ClassPath classPath;

    public CliVirtualFileFinder(@NotNull ClassPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "<init>"));
        }
        this.classPath = path;
    }

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "findVirtualFileWithHeader"));
        }
        for (VirtualFile root : this.classPath) {
            VirtualFile fileInRoot = CliVirtualFileFinder.findFileInRoot(className.asString(), root, '.');
            if (fileInRoot == null || KotlinBinaryClassCache.getKotlinBinaryClass(fileInRoot) == null) continue;
            return fileInRoot;
        }
        return null;
    }

    @Override
    public VirtualFile findVirtualFile(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "findVirtualFile"));
        }
        for (VirtualFile root : this.classPath) {
            VirtualFile fileInRoot = CliVirtualFileFinder.findFileInRoot(internalName, root, '/');
            if (fileInRoot == null) continue;
            return fileInRoot;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFileInRoot(@NotNull String qName, @NotNull VirtualFile root, char separator) {
        String pathComponent;
        VirtualFile child;
        int dot;
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "findFileInRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "findFileInRoot"));
        }
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(separator)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String className = pathRest.replace('.', '$');
        VirtualFile vFile = cur.findChild(className + ".class");
        if (vFile != null) {
            if (!vFile.isValid()) {
                return null;
            }
            return vFile;
        }
        return null;
    }
}

