/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.callTranslator;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.test.TestPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage$computeExplicitReceiversForInvoke$1;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage-CallInfo-ec9c7a75;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage-FunctionCallCases-88a17fa0;
import org.jetbrains.k2js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.k2js.translate.context.TranslationContext;

@KotlinSyntheticClass(abiVersion=15, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class CallTranslatorPackage-CallTranslator-ac389489 {
    public static final boolean expectedReceivers(@JetValueParameter(name="$receiver") ResolvedCall<? extends CallableDescriptor> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    @NotNull
    public static final JsExpression translateCall(@JetValueParameter(name="context") @NotNull TranslationContext context, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
        }
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            boolean bl = true;
            if (explicitReceivers.getReceiverObject() != null) {
                bl = false;
            }
            KotlinPackage.assert(bl, "VariableAsFunctionResolvedCall must have one receiver");
            ResolvedCallWithTrace<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall();
            if (CallTranslatorPackage-CallTranslator-ac389489.expectedReceivers((ResolvedCall<? extends CallableDescriptor>)variableCall)) {
                JsExpression newReceiver = CallTranslator.instance$.translateGet(context, (ResolvedCall<? extends VariableDescriptor>)variableCall, explicitReceivers.getReceiverOrThisObject());
                JsExpression jsExpression = CallTranslatorPackage-CallTranslator-ac389489.translateFunctionCall(context, (ResolvedCall<? extends FunctionDescriptor>)((VariableAsFunctionResolvedCall)resolvedCall).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
                }
                return jsExpression;
            }
            JsExpression thisObject = CallTranslator.instance$.translateGet(context, (ResolvedCall<? extends VariableDescriptor>)variableCall, null);
            boolean bl2 = true;
            if (explicitReceivers.getReceiverOrThisObject() != null) {
                bl2 = false;
            }
            if (bl2) {
                JsExpression jsExpression = CallTranslatorPackage-CallTranslator-ac389489.translateFunctionCall(context, (ResolvedCall<? extends FunctionDescriptor>)((VariableAsFunctionResolvedCall)resolvedCall).getFunctionCall(), new ExplicitReceivers(thisObject, null, 2));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
                }
                return jsExpression;
            }
            JsExpression jsExpression = CallTranslatorPackage-CallTranslator-ac389489.translateFunctionCall(context, (ResolvedCall<? extends FunctionDescriptor>)((VariableAsFunctionResolvedCall)resolvedCall).getFunctionCall(), new ExplicitReceivers(thisObject, explicitReceivers.getReceiverOrThisObject()));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
            }
            return jsExpression;
        }
        Call call = resolvedCall.getCall();
        boolean bl = Intrinsics.areEqual((Object)call.getCallType(), (Object)Call.CallType.INVOKE) ? !CallResolverUtil.isInvokeCallOnVariable(call) : false;
        if (bl) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorPackage-CallTranslator-ac389489.computeExplicitReceiversForInvoke(context, resolvedCall, explicitReceivers);
            JsExpression jsExpression = CallTranslatorPackage-CallTranslator-ac389489.translateFunctionCall(context, resolvedCall, explicitReceiversForInvoke);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = CallTranslatorPackage-CallTranslator-ac389489.translateFunctionCall(context, resolvedCall, explicitReceivers);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateCall"));
        }
        return jsExpression;
    }

    @NotNull
    public static final JsExpression translateFunctionCall(@JetValueParameter(name="context") @NotNull TranslationContext context, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateFunctionCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateFunctionCall"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateFunctionCall"));
        }
        JsExpression jsExpression = CallTranslatorPackage-FunctionCallCases-88a17fa0.translateFunctionCall(CallTranslatorPackage-CallInfo-ec9c7a75.getCallInfo(context, resolvedCall, explicitReceivers));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "translateFunctionCall"));
        }
        return jsExpression;
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@JetValueParameter(name="context") @NotNull TranslationContext context, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "computeExplicitReceiversForInvoke"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "computeExplicitReceiversForInvoke"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "computeExplicitReceiversForInvoke"));
        }
        PsiElement callElement = resolvedCall.getCall().getCallElement();
        boolean bl = true;
        if (explicitReceivers.getReceiverObject() != null) {
            bl = false;
        }
        KotlinPackage.assert(bl, "'Invoke' call must have one receiver: " + callElement);
        CallTranslatorPackage$computeExplicitReceiversForInvoke$1 callTranslatorPackage$computeExplicitReceiversForInvoke$1 = new CallTranslatorPackage$computeExplicitReceiversForInvoke$1(context);
        ReceiverValue thisObject = resolvedCall.getThisObject();
        ReceiverValue receiverArgument2 = resolvedCall.getReceiverArgument();
        if (thisObject.exists() ? receiverArgument2.exists() : false) {
            TestPackage.assertNotNull(explicitReceivers.getReceiverOrThisObject(), "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement);
        } else {
            boolean bl2 = true;
            if (explicitReceivers.getReceiverOrThisObject() != null) {
                bl2 = false;
            }
            KotlinPackage.assert(bl2, "Non trivial explicit receiver " + explicitReceivers.getReceiverOrThisObject() + "\n" + " for 'invoke' resolved call: " + callElement + "\n" + ("This object: " + thisObject + " Receiver argument: " + receiverArgument2));
        }
        JsExpression thisObjectExpression = callTranslatorPackage$computeExplicitReceiversForInvoke$1.invoke(thisObject);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(thisObject.exists(), receiverArgument2.exists());
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(thisObjectExpression, explicitReceivers.getReceiverOrThisObject());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(thisObjectExpression, null, 2);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            explicitReceivers2 = new ExplicitReceivers(callTranslatorPackage$computeExplicitReceiversForInvoke$1.invoke(receiverArgument2), null, 2);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        if (explicitReceivers2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage-CallTranslator-ac389489", "computeExplicitReceiversForInvoke"));
        }
        return explicitReceivers2;
    }
}

