/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.JavaToKotlinMethodMapGenerated;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaSignatureFormatter;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class JavaToKotlinMethodMap {
    public static final JavaToKotlinMethodMap INSTANCE = new JavaToKotlinMethodMap();
    private final JavaToKotlinMethodMapGenerated mapContainer = new JavaToKotlinMethodMapGenerated();

    private JavaToKotlinMethodMap() {
    }

    @NotNull
    public List<FunctionDescriptor> getFunctions(@NotNull JavaMethod javaMethod, @NotNull FqName classFqName, @NotNull ClassDescriptor containingClass) {
        if (javaMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaMethod", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap", "getFunctions"));
        }
        if (classFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFqName", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap", "getFunctions"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap", "getFunctions"));
        }
        Collection classDatas = this.mapContainer.map.get((Object)classFqName.asString());
        ArrayList<FunctionDescriptor> result2 = Lists.newArrayList();
        Set<ClassDescriptor> allSuperClasses = DescriptorUtils.getAllSuperClasses(containingClass);
        String serializedMethod = JavaSignatureFormatter.getInstance().formatMethod(javaMethod);
        for (ClassData classData : classDatas) {
            ClassDescriptor kotlinClass;
            String expectedSerializedFunction = classData.method2Function.get(serializedMethod);
            if (expectedSerializedFunction == null || !allSuperClasses.contains(kotlinClass = classData.kotlinClass)) continue;
            Collection<FunctionDescriptor> functions2 = kotlinClass.getDefaultType().getMemberScope().getFunctions(javaMethod.getName());
            for (FunctionDescriptor function : functions2) {
                if (!expectedSerializedFunction.equals(JavaToKotlinMethodMap.serializeFunction(function))) continue;
                result2.add(function);
            }
        }
        ArrayList<FunctionDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap", "getFunctions"));
        }
        return arrayList;
    }

    @NotNull
    public static String serializeFunction(@NotNull FunctionDescriptor fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap", "serializeFunction"));
        }
        String string = DescriptorRenderer.COMPACT.render(fun);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap", "serializeFunction"));
        }
        return string;
    }

    static Pair<String, String> pair(String a, String b) {
        return Pair.create(a, b);
    }

    static void put(ImmutableMultimap.Builder<String, ClassData> builder, String javaFqName, String kotlinQualifiedName, Pair<String, String> ... methods2Functions) {
        ClassDescriptor kotlinClass;
        ImmutableMap<String, String> methods2FunctionsMap = JavaToKotlinMethodMap.pairs2Map(methods2Functions);
        if (kotlinQualifiedName.contains(".")) {
            String[] kotlinNames = kotlinQualifiedName.split("\\.");
            assert (kotlinNames.length == 2) : "unexpected qualified name " + kotlinQualifiedName;
            ClassDescriptor outerClass = KotlinBuiltIns.getInstance().getBuiltInClassByName(Name.identifier(kotlinNames[0]));
            kotlinClass = DescriptorUtils.getInnerClassByName(outerClass, kotlinNames[1]);
            assert (kotlinClass != null) : "Class not found: " + kotlinQualifiedName;
        } else {
            kotlinClass = KotlinBuiltIns.getInstance().getBuiltInClassByName(Name.identifier(kotlinQualifiedName));
        }
        builder.put(javaFqName, new ClassData(kotlinClass, methods2FunctionsMap));
    }

    private static ImmutableMap<String, String> pairs2Map(Pair<String, String>[] pairs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Pair<String, String> pair : pairs) {
            builder.put(pair.first, pair.second);
        }
        return builder.build();
    }

    static class ClassData {
        @NotNull
        public final ClassDescriptor kotlinClass;
        @NotNull
        public Map<String, String> method2Function;

        public ClassData(@NotNull ClassDescriptor kotlinClass, @NotNull Map<String, String> method2Function) {
            if (kotlinClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap$ClassData", "<init>"));
            }
            if (method2Function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2Function", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/JavaToKotlinMethodMap$ClassData", "<init>"));
            }
            this.kotlinClass = kotlinClass;
            this.method2Function = method2Function;
        }
    }
}

