/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.inline.FieldRemapper;
import org.jetbrains.jet.codegen.inline.LocalVarRemapper;
import org.jetbrains.jet.codegen.inline.RegeneratedLambdaFieldRemapper;

public class RemapVisitor
extends InstructionAdapter {
    private final Label end;
    private final LocalVarRemapper remapper;
    private final boolean remapReturn;
    private final FieldRemapper nodeRemapper;
    private final InstructionAdapter instructionAdapter;

    protected RemapVisitor(MethodVisitor mv, Label end, LocalVarRemapper localVarRemapper, boolean remapReturn, FieldRemapper nodeRemapper) {
        super(262144, mv);
        this.instructionAdapter = new InstructionAdapter(mv);
        this.end = end;
        this.remapper = localVarRemapper;
        this.remapReturn = remapReturn;
        this.nodeRemapper = nodeRemapper;
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.remapReturn && opcode >= 172 && opcode <= 177) {
            super.visitJumpInsn(167, this.end);
        } else {
            super.visitInsn(opcode);
        }
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.remapper.visitIincInsn(var, increment, this.mv);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.remapper.visitVarInsn(opcode, var, this.instructionAdapter);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.remapper.visitLocalVariable(name, desc, signature, start, end, index, this.mv);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (name.startsWith("$$$")) {
            if (this.nodeRemapper instanceof RegeneratedLambdaFieldRemapper || this.nodeRemapper.isRoot()) {
                FieldInsnNode fin = new FieldInsnNode(opcode, owner, name, desc);
                StackValue inline2 = this.nodeRemapper.getFieldForInline(fin, null);
                assert (inline2 != null) : "Captured field should have not null stackValue " + fin;
                inline2.put(inline2.type, this);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }
}

