/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.OpenTHashSet;
import org.jetbrains.annotations.NotNull;

public class Interner<T> {
    private final OpenTHashSet<T> mySet = new OpenTHashSet();

    @NotNull
    public T intern(@NotNull T name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/Interner", "intern"));
        }
        T interned = this.mySet.get(name);
        if (interned != null) {
            T t = interned;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Interner", "intern"));
            }
            return t;
        }
        boolean added = this.mySet.add(name);
        assert (added);
        T t = name;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Interner", "intern"));
        }
        return t;
    }
}

