/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

class ClsPackageStatementImpl
extends ClsElementImpl
implements PsiPackageStatement {
    private final ClsFileImpl myFile;
    private final String myPackageName;

    public ClsPackageStatementImpl(@NotNull ClsFileImpl file) {
        int index;
        String className;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsPackageStatementImpl", "<init>"));
        }
        this.myFile = file;
        String packageName = null;
        PsiClass[] psiClasses = file.getClasses();
        if (psiClasses.length > 0 && (className = psiClasses[0].getQualifiedName()) != null && (index = className.lastIndexOf(46)) >= 0) {
            packageName = className.substring(0, index);
        }
        this.myPackageName = packageName;
    }

    @Override
    public PsiElement getParent() {
        return this.myFile;
    }

    @Override
    public PsiJavaCodeReferenceElement getPackageReference() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public PsiModifierList getAnnotationList() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsPackageStatementImpl", "appendMirrorText"));
        }
        if (this.myPackageName != null) {
            buffer.append("package ").append(this.getPackageName()).append(";");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsPackageStatementImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.PACKAGE_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsPackageStatementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackageStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackageStatement:" + this.getPackageName();
    }
}

