/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.translate.test.JSTester;
import org.jetbrains.k2js.translate.test.QUnitTester;

public abstract class Config {
    @NotNull
    public static final String REWRITABLE_MODULE_NAME = "JS_TESTS";
    @NotNull
    public static final List<String> LIB_FILES_WITH_DECLARATIONS = Arrays.asList("/core/annotations.kt", "/core/core.kt", "/core/date.kt", "/core/dom.kt", "/core/javaio.kt", "/core/javalang.kt", "/core/javautil.kt", "/core/javautilCollections.kt", "/core/json.kt", "/core/kotlin.kt", "/core/math.kt", "/core/string.kt", "/core/htmlDom.kt", "/html5/canvas.kt", "/jquery/common.kt", "/jquery/ui.kt", "/junit/core.kt", "/qunit/core.kt", "/stdlib/browser.kt");
    @NotNull
    public static final List<String> LIB_FILES_WITH_CODE = Arrays.asList("/stdlib/TuplesCode.kt", "/core/javautilCollectionsCode.kt");
    @NotNull
    public static final List<String> LIB_FILE_NAMES = Lists.newArrayList();
    @NotNull
    public static final List<String> LIB_FILE_NAMES_DEPENDENT_ON_STDLIB;
    public static final String LIBRARIES_LOCATION = "js/js.libraries/src";
    @NotNull
    public static final List<String> STDLIB_FILE_NAMES;
    public static final String STDLIB_LOCATION = "libraries/stdlib/src";
    @NotNull
    private final Project project;
    @Nullable
    private List<JetFile> libFiles;
    @NotNull
    private final EcmaVersion target;
    @NotNull
    private final String moduleId;
    private final boolean sourcemap;

    @NotNull
    public static Config getEmptyConfig(@NotNull Project project, @NotNull EcmaVersion ecmaVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/Config", "getEmptyConfig"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/Config", "getEmptyConfig"));
        }
        Config config = new Config(project, "main", ecmaVersion){

            @Override
            @NotNull
            protected List<JetFile> generateLibFiles() {
                List<JetFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config$1", "generateLibFiles"));
                }
                return list;
            }
        };
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getEmptyConfig"));
        }
        return config;
    }

    @NotNull
    public static Config getEmptyConfig(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/Config", "getEmptyConfig"));
        }
        Config config = Config.getEmptyConfig(project, EcmaVersion.defaultVersion());
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getEmptyConfig"));
        }
        return config;
    }

    public Config(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        this(project, moduleId, ecmaVersion, false);
    }

    public Config(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion, boolean sourcemap) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        this.libFiles = null;
        this.project = project;
        this.target = ecmaVersion;
        this.moduleId = moduleId;
        this.sourcemap = sourcemap;
    }

    public boolean isSourcemap() {
        return this.sourcemap;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getProject"));
        }
        return project;
    }

    @NotNull
    public EcmaVersion getTarget() {
        EcmaVersion ecmaVersion = this.target;
        if (ecmaVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getTarget"));
        }
        return ecmaVersion;
    }

    @NotNull
    public String getModuleId() {
        String string = this.moduleId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getModuleId"));
        }
        return string;
    }

    @NotNull
    protected abstract List<JetFile> generateLibFiles();

    @NotNull
    public final List<JetFile> getLibFiles() {
        if (this.libFiles == null) {
            this.libFiles = this.generateLibFiles();
        }
        List<JetFile> list = this.libFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getLibFiles"));
        }
        return list;
    }

    @Nullable
    public BindingContext getLibraryContext() {
        return null;
    }

    @Nullable
    public ModuleDescriptor getLibraryModule() {
        return null;
    }

    @NotNull
    public static Collection<JetFile> withJsLibAdded(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/config/Config", "withJsLibAdded"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/config/Config", "withJsLibAdded"));
        }
        ArrayList<JetFile> allFiles = Lists.newArrayList();
        allFiles.addAll(files);
        allFiles.addAll(config.getLibFiles());
        ArrayList<JetFile> arrayList = allFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "withJsLibAdded"));
        }
        return arrayList;
    }

    @Nullable
    public JSTester getTester() {
        return new QUnitTester();
    }

    static {
        LIB_FILE_NAMES.addAll(LIB_FILES_WITH_DECLARATIONS);
        LIB_FILE_NAMES.addAll(LIB_FILES_WITH_CODE);
        LIB_FILE_NAMES_DEPENDENT_ON_STDLIB = Arrays.asList("/core/stringsCode.kt", "/stdlib/domCode.kt", "/stdlib/jutilCode.kt", "/stdlib/testCode.kt");
        STDLIB_FILE_NAMES = Arrays.asList("/kotlin/Preconditions.kt", "/kotlin/Functions.kt", "/kotlin/collections/JUtil.kt", "/kotlin/collections/Iterators.kt", "/kotlin/collections/Arrays.kt", "/kotlin/collections/Maps.kt", "/kotlin/collections/Exceptions.kt", "/kotlin/collections/MutableCollections.kt", "/kotlin/collections/Stream.kt", "/kotlin/collections/AbstractIterator.kt", "/generated/_Aggregates.kt", "/generated/_Arrays.kt", "/generated/_DownTo.kt", "/generated/_Elements.kt", "/generated/_Filtering.kt", "/generated/_Generators.kt", "/generated/_Guards.kt", "/generated/_Mapping.kt", "/generated/_Numeric.kt", "/generated/_Ordering.kt", "/generated/_Snapshots.kt", "/generated/_Strings.kt", "/generated/_Streams.kt", "/kotlin/Standard.kt", "/kotlin/text/Strings.kt", "/kotlin/dom/Dom.kt", "/kotlin/test/Test.kt");
    }
}

