/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;

public class BuiltInsSerializationUtil {
    private BuiltInsSerializationUtil() {
    }

    @NotNull
    public static String relativeClassNameToFilePath(@NotNull FqNameUnsafe className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "relativeClassNameToFilePath"));
        }
        List<Name> segments = className.pathSegments();
        ArrayList<String> correctedSegments = new ArrayList<String>(segments.size());
        for (Name segment : segments) {
            correctedSegments.add(SpecialNames.isClassObjectName(segment) ? "object" : segment.getIdentifier());
        }
        String string = FqName.fromSegments(correctedSegments).asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "relativeClassNameToFilePath"));
        }
        return string;
    }

    @NotNull
    public static String getClassMetadataPath(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassMetadataPath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(classId.getPackageFqName()) + "/" + BuiltInsSerializationUtil.relativeClassNameToFilePath(classId.getRelativeClassName()) + "." + "kotlin_class";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassMetadataPath"));
        }
        return string;
    }

    @NotNull
    public static String getPackageFilePath(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getPackageFilePath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(fqName) + "/" + ".kotlin_package";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getPackageFilePath"));
        }
        return string;
    }

    @NotNull
    public static String getNameTableFilePath(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getNameTableFilePath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(fqName) + "/" + ".kotlin_name_table";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getNameTableFilePath"));
        }
        return string;
    }

    @NotNull
    public static String getClassNamesFilePath(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassNamesFilePath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(fqName) + "/" + ".kotlin_class_names";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassNamesFilePath"));
        }
        return string;
    }

    private static String packageFqNameToPath(FqName fqName) {
        return fqName.asString().replace('.', '/');
    }
}

