/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverloadUtil;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class OverloadResolver {
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverloadResolver", "process"));
        }
        this.checkOverloads(c);
    }

    private void checkOverloads(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloads"));
        }
        MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses = MultiMap.create();
        MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages = MultiMap.create();
        this.fillGroupedConstructors(c, inClasses, inPackages);
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getClasses().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), entry.getKey(), inClasses.get(entry.getValue()));
        }
        this.checkOverloadsInPackages(c, inPackages);
    }

    private void fillGroupedConstructors(@NotNull BodiesResolveContext c, @NotNull MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses, @NotNull MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        if (inClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inClasses", "org/jetbrains/jet/lang/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        if (inPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inPackages", "org/jetbrains/jet/lang/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        for (ClassDescriptorWithResolutionScopes klass : c.getClasses().values()) {
            if (klass.getKind().isSingleton()) continue;
            DeclarationDescriptor containingDeclaration = klass.getContainingDeclaration();
            if (containingDeclaration instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                inClasses.put(classDescriptor, klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof PackageFragmentDescriptor) {
                inPackages.put(DescriptorUtils.getFqName(klass), klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor) continue;
            throw new IllegalStateException();
        }
    }

    private void checkOverloadsInPackages(@NotNull BodiesResolveContext c, @NotNull MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloadsInPackages"));
        }
        if (inPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inPackages", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloadsInPackages"));
        }
        MultiMap<FqNameUnsafe, CallableMemberDescriptor> functionsByName = MultiMap.create();
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : c.getFunctions().values()) {
            if (!(simpleFunctionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            functionsByName.putValue(DescriptorUtils.getFqName(simpleFunctionDescriptor), simpleFunctionDescriptor);
        }
        for (PropertyDescriptor propertyDescriptor : c.getProperties().values()) {
            if (!(propertyDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            functionsByName.putValue(DescriptorUtils.getFqName(propertyDescriptor), propertyDescriptor);
        }
        for (Map.Entry entry : inPackages.entrySet()) {
            functionsByName.putValues((FqNameUnsafe)entry.getKey(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((Collection)entry.getValue(), ((FqNameUnsafe)entry.getKey()).parent().asString());
        }
    }

    private static String nameForErrorMessage(ClassDescriptor classDescriptor, JetClassOrObject jetClass) {
        String name = jetClass.getName();
        if (name != null) {
            return name;
        }
        if (jetClass instanceof JetObjectDeclaration) {
            name = classDescriptor.getContainingDeclaration().getName().asString();
            return "class object " + name;
        }
        return "<unknown>";
    }

    private void checkOverloadsInAClass(ClassDescriptorWithResolutionScopes classDescriptor, JetClassOrObject klass, Collection<ConstructorDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> functionsByName = MultiMap.create();
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            ClassDescriptorWithResolutionScopes classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
            assert (classObjectDescriptor != null);
            for (CallableMemberDescriptor memberDescriptor : classObjectDescriptor.getDeclaredCallableMembers()) {
                functionsByName.putValue(memberDescriptor.getName(), memberDescriptor);
            }
        }
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            functionsByName.putValue(callableMemberDescriptor.getName(), callableMemberDescriptor);
        }
        for (ConstructorDescriptor constructorDescriptor : nestedClassConstructors) {
            functionsByName.putValue(constructorDescriptor.getContainingDeclaration().getName(), constructorDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((Collection)entry.getValue(), OverloadResolver.nameForErrorMessage(classDescriptor, klass));
        }
    }

    private void checkOverloadsWithSameName(Collection<CallableMemberDescriptor> functions2, @NotNull String functionContainer) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloadsWithSameName"));
        }
        if (functions2.size() == 1) {
            return;
        }
        Set<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations = this.findRedeclarations(functions2);
        this.reportRedeclarations(functionContainer, redeclarations);
    }

    @NotNull
    private Set<Pair<JetDeclaration, CallableMemberDescriptor>> findRedeclarations(@NotNull Collection<CallableMemberDescriptor> functions2) {
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/lang/resolve/OverloadResolver", "findRedeclarations"));
        }
        HashSet<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations = Sets.newHashSet();
        for (CallableMemberDescriptor member : functions2) {
            for (CallableMemberDescriptor member2 : functions2) {
                JetDeclaration jetDeclaration;
                OverloadUtil.OverloadCompatibilityInfo overloadable;
                if (member == member2 || (overloadable = OverloadUtil.isOverloadable(member, member2)).isSuccess() || (jetDeclaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), member)) == null) continue;
                redeclarations.add(Pair.create(jetDeclaration, member));
            }
        }
        HashSet<Pair<JetDeclaration, CallableMemberDescriptor>> hashSet = redeclarations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverloadResolver", "findRedeclarations"));
        }
        return hashSet;
    }

    private void reportRedeclarations(@NotNull String functionContainer, @NotNull Set<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/jet/lang/resolve/OverloadResolver", "reportRedeclarations"));
        }
        if (redeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarations", "org/jetbrains/jet/lang/resolve/OverloadResolver", "reportRedeclarations"));
        }
        for (Pair<JetDeclaration, CallableMemberDescriptor> redeclaration : redeclarations) {
            CallableMemberDescriptor memberDescriptor = redeclaration.getSecond();
            JetDeclaration jetDeclaration = redeclaration.getFirst();
            if (memberDescriptor instanceof PropertyDescriptor) {
                this.trace.report(Errors.REDECLARATION.on(jetDeclaration, memberDescriptor.getName().asString()));
                continue;
            }
            this.trace.report(Errors.CONFLICTING_OVERLOADS.on(jetDeclaration, memberDescriptor, functionContainer));
        }
    }
}

