/*
 * Decompiled with CFR 0.152.
 */
package jsr166e.extra;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class SequenceLock
implements Serializable,
Lock {
    private final Sync sync = new Sync(DEFAULT_SPINS);
    static final int DEFAULT_SPINS = Runtime.getRuntime().availableProcessors() > 1 ? 64 : 0;

    @Override
    public void lock() {
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireInterruptibly(1L);
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryAcquire(1L);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireNanos(1L, unit.toNanos(timeout));
    }

    @Override
    public void unlock() {
        this.sync.release(1L);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Thread o = this.sync.getOwner();
        return super.toString() + (o == null ? "[Unlocked]" : "[Locked by thread " + o.getName() + "]");
    }

    static final class Sync
    extends AbstractQueuedLongSynchronizer {
        final int spins;
        long holds;

        Sync(int spins) {
            this.spins = spins;
        }

        @Override
        public final boolean isHeldExclusively() {
            return (this.getState() & 1L) != 0L && this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        @Override
        public final boolean tryAcquire(long acquires) {
            Thread current = Thread.currentThread();
            long c = this.getState();
            if ((c & 1L) == 0L) {
                if (this.compareAndSetState(c, c + 1L)) {
                    this.holds = acquires;
                    this.setExclusiveOwnerThread(current);
                    return true;
                }
            } else if (current == this.getExclusiveOwnerThread()) {
                this.holds += acquires;
                return true;
            }
            return false;
        }

        @Override
        public final boolean tryRelease(long releases) {
            if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException();
            }
            if ((this.holds -= releases) == 0L) {
                this.setExclusiveOwnerThread(null);
                this.setState(this.getState() + 1L);
                return true;
            }
            return false;
        }

        @Override
        public final long tryAcquireShared(long unused) {
            return (this.getState() & 1L) == 0L ? 1L : (this.getExclusiveOwnerThread() == Thread.currentThread() ? 0L : -1L);
        }

        @Override
        public final boolean tryReleaseShared(long unused) {
            return (this.getState() & 1L) == 0L;
        }

        final void lock() {
            int k = this.spins;
            while (!this.tryAcquire(1L)) {
                if (k == 0) {
                    this.acquire(1L);
                    break;
                }
                --k;
            }
        }

        final Thread getOwner() {
            return (this.getState() & 1L) == 0L ? null : this.getExclusiveOwnerThread();
        }
    }
}

